///@brief サーバ側ヘッダ
///

#include "vncviewer.h"
#include <sys/time.h>

/* cursor.c */

extern Bool HandleCursorShape(int xhot, int yhot, int width, int height,
                              CARD32 enc);
extern void SoftCursorLockArea(int x, int y, int w, int h);
extern void SoftCursorUnlockScreen(void);
extern void SoftCursorMove(int x, int y);
extern Bool HandleCursorPos(int x, int y);

extern Window desktopWin;

/* listen.c */

extern Bool listenSpecified;

/* rfbproto.c */

extern char *desktopName;
extern char *serverCutText;
extern Bool newServerCutText;

extern Bool InitialiseRFBConnection();
extern Bool SetFormatAndEncodings();
extern Bool SendIncrementalFramebufferUpdateRequest();
extern Bool SendFramebufferUpdateRequest(int x, int y, int w, int h,
					 Bool incremental);
extern Bool SendPointerEvent(int x, int y, int buttonMask);
extern Bool SendKeyEvent(CARD32 key, Bool down);
extern Bool HandleRFBServerMessage();

extern Bool SendAllFramebufferUpdateRequest();

extern Bool SendAllFramebufferUpdateRequestSpecified( int sock );
extern Bool SendPointerEventSpecified(int x, int y, int buttonMask, int sock);
extern Bool SendKeyEventSpecified(CARD32 key, Bool down, int sock);
extern Bool SendFramebufferUpdateRequestSpecified(int x, int y, int w, int h,
					 Bool incremental, int sock);
#define MAX_ENCODINGS 20

extern void SendCast (int cnum);

/* shm.c */

extern Visual *vis;
extern unsigned int visdepth;

/* sockets.c */

extern Bool errorMessageOnReadFailure;

extern Bool ReadFromRFBServer(char *out, unsigned int n);
extern Bool WriteExact(int sock, char *buf, int n);

/* vncviewer.c */

extern char *programName;
extern XtAppContext appContext;

/* multi.c */

extern int clientNum;
extern gint gdk_input_add_priority (gint source, GdkInputCondition condition,
	GdkInputFunction function, gpointer data, gint priority);

/* image_processing_s.c */
extern void GetHistogram (int clientNum, char *buf, int socket);

/* desktop_s.c */
extern void DesktopInitAfterRealization();
extern void CopyDataToScreen(char *buf, int x, int y, int width, int height);

/* draw_s.c */
extern void window_copy_area( GdkWindow *window, GdkGC *gc, gint x, gint y,
			      GdkWindow *source_window,
			      gint source_x, gint source_y,
			      gint width, gint height );
extern void CreateImageInfo( gboolean flag );
extern void DestroyImageInfo(int c_num);

