/*
 *  Copyright (C) 1999 AT&T Laboratories Cambridge.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

/*
 * desktop.c - functions to deal with "desktop" window.
 */

#include "vncviewer.h"

GdkImage *gdkimage[MAXCLIENT];
GdkImage *smallimage[MAXCLIENT];

void
CopyDataFromScreen( char *buf, int x, int y, int width, int height )
{
  int widthInBytes = width * myFormat.bitsPerPixel / 8;
  //int scrWidthInBytes = server_CB.client_grp[clientNum]->serverInitMsg.framebufferWidth * myFormat.bitsPerPixel / 8;
  int scrWidthInBytes = si.framebufferWidth * myFormat.bitsPerPixel / 8;
  char *scr = gdkimage[clientNum]->mem + y * scrWidthInBytes + x * myFormat.bitsPerPixel / 8;
  int h;
  for( h = 0; h < height; h++ ){
    memcpy( buf, scr, widthInBytes );
    scr += scrWidthInBytes;
    buf += widthInBytes;
  }
  return;
}
