#ifndef IMAGE_PROCESSING_H
#define IMAGE_PROCESSING_H

//macro
#define dbg(...) (fprintf(stderr, "@@debug :: %s %u@%s:",__FILE__,__LINE__,__func__),fprintf(stderr, ""__VA_ARGS__),fprintf(stderr, "\n"))
#define err(...) (fprintf(stderr, "@@error :: %s %u@%s:%s:",__FILE__,__LINE__,__func__,strerror(errno)),fprintf(stderr, ""__VA_ARGS__),fprintf(stderr, "\n"))


#define DEFAULT_GETIMAGE_INTERVAL 60
#define DEFAULT_OPESTATE_INTERVAL 60
#define LENGTH_TIME_SEQ 10

//Max Value
#define MAX_GETIMAGE_INTERVAL 600
#define MAX_OPESTATE_INTERVAL 600
#define MAX_FREEZE_COUNT 60

//Min Value
#define MIN_GETIMAGE_INTERVAL 1
#define MIN_OPESTATE_INTERVAL 1
#define MIN_FREEZE_COUNT 1

#define MAX_HIST 256
#define NORMALIZE_HIST 76800

//#define MAX_CLIENT 50
#define MATCHING_RATIO 0.95


typedef struct time_sequence
{
    int now;
    int length;
} TS;



extern Display *display;
extern pthread_mutex_t c_mutex;
extern pthread_mutex_t s_mutex;
extern pthread_t c_thread;
extern pthread_t s_thread;


void RGBtoHSV(int r,int g,int b,int *h,int *s,int *v);

void tsInit(TS *ts,int length);
void tsPutForward(TS *ts);
int tsPrev(TS *ts,int time);

extern void *image_proc_server (void *arg);
extern void *image_proc_client (void *arg);

extern void request_opeStateDecision(struct client_cb *client_CB);

#endif
