/*
 *  Copyright (C) 2000, 2001 Const Kaplinsky.  All Rights Reserved.
 *  Copyright (C) 2000 Tridia Corporation.  All Rights Reserved.
 *  Copyright (C) 1999 AT&T Laboratories Cambridge.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

/*
 * vncviewer.h
 */

#include <stdlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xmd.h>
#include <gtk/gtk.h>
#include <netinet/in.h>

#include "../include/rfbproto.h"

#include "../include/multi.h"

#include "image_processing.h"

extern int endianTest;

#define Swap16IfLE(s) \
    (*(char *)&endianTest ? ((((s) & 0xff) << 8) | (((s) >> 8) & 0xff)) : (s))

#define Swap32IfLE(l) \
    (*(char *)&endianTest ? ((((l) & 0xff000000) >> 24) | \
			     (((l) & 0x00ff0000) >> 8)  | \
			     (((l) & 0x0000ff00) << 8)  | \
			     (((l) & 0x000000ff) << 24))  : (l))

/* gdk */

extern GtkWidget *drawingarea[][ROW_MAX * COLUMN_MAX];
extern GdkPixmap *gdkpixmap[TAB_MAX][ROW_MAX * COLUMN_MAX];
extern int da_num;
extern int page;
extern GtkWidget *drawingarea_ex;
extern GdkPixmap *pixmap_ex;
extern GdkImage *smallimage_ex;

/* common */

typedef struct {
  Bool shareDesktop;
  Bool viewOnly;
  Bool grabKeyboard;
  Bool raiseOnBeep;

  String encodingsString;

  Bool useBGR233;
  int nColours;
  Bool useSharedColours;
  int requestedDepth;

  Bool useShm;

  int wmDecorationWidth;
  int wmDecorationHeight;

  char *passwordFile;
  Bool passwordDialog;

  int rawDelay;

  Bool debug;

  int popupButtonCount;

  int bumpScrollTime;
  int bumpScrollPixels;

  int compressLevel;
  int qualityLevel;
  Bool enableJPEG;
  Bool useRemoteCursor;
  Bool useX11Cursor;

} AppData;

extern AppData appData;

extern int rfbsock;
extern rfbPixelFormat myFormat;
extern rfbServerInitMsg si;
extern char *programName;

extern Display* dpy;

extern void PrintPixelFormat(rfbPixelFormat *format);

extern void ToplevelInitBeforeRealization();
extern void Cleanup();

/* colour.c */

extern unsigned long BGR233ToPixel[];
extern GdkColormap *gdkcmap;
extern GdkVisual *gdkvis;
extern gint gdkvisdepth, gdkvisbpp;
extern Colormap cmap;

extern void SetVisualAndCmap();

/* desktop.c */

#define SHIFTVAL  10
#define SHIFTMASK 1023     // ( 1 << SHIFTVAL - 1 )
#define SHIFTMAX  1024     // ( 1 << SHIFTVAL )
#define SHIFTMAX2 2048     // ( 1 << SHIFTVAL ) * 2
#define AVERAGESHIFT 12    // ( SHIFTVAL + 2 )

extern Widget form, viewport, desktop;
extern Cursor dotCursor;
extern GC gc;
extern GdkCursor *gdkdotCursor;
extern GdkGC *gdkGC;
extern GdkGC *gdksrcGC;
extern GdkGC *gdkdstGC;
extern GdkImage *gdkimage[];
extern GdkImage *smallimage[];

extern void CopyDataFromScreen(char *buf, int x, int y, int width, int height);

/* draw.c */
extern void draw_rectangle( GdkDrawable *drawable, GdkGC *gc, gint filled,
			    gint x, gint y, gint width, gint height, int color );
extern void draw_image( GdkDrawable *drawable, GdkGC *gc, GdkImage *image,
			gint xsrc, gint ysrc, gint xdest, gint ydest,
			gint width, gint height );
extern void FillRectangle( int color, int x, int y, int width, int height, int bpp, GdkImage *image );
typedef struct {
  int widthSrcToDst;
  int widthDstToSrc;
  int heightSrcToDst;
  int heightDstToSrc;
}IMAGEINFO;
extern int reducedWindowWidth;
extern int reducedWindowHeight;
