/* vi:set ts=8 sts=4 sw=4:
 *
 * VIM - Vi IMproved	by Bram Moolenaar
 *
 * Do ":help uganda"  in Vim to read copying and usage conditions.
 * Do ":help credits" in Vim to see a list of people who contributed.
 */

/*
 * proto.h: include the (automatically generated) function prototypes
 */

/*
 * Don't include these while generating prototypes.  Prevents problems when
 * files are missing.
 */
#if !defined(PROTO) && !defined(NOPROTO)

/*
 * Machine-dependent routines.
 */
# ifdef AMIGA
#  include "proto/os_amiga.pro"
# endif
# if defined(UNIX) || defined(__EMX__)
#  include "proto/os_unix.pro"
# endif
# ifdef MSDOS
#  include "proto/os_msdos.pro"
# endif
# ifdef WIN32
#  include "proto/os_win32.pro"
# endif
# ifdef VMS
#  include "proto/os_vms.pro"
# endif
# ifdef __BEOS__
#  include "proto/os_beos.pro"
# endif
# ifdef macintosh
#  include "proto/os_mac.pro"
# endif
# ifdef RISCOS
#  include "proto/os_riscos.pro"
# endif

# include "proto/buffer.pro"
# include "proto/charset.pro"
# ifdef UNIX
#  include "proto/if_cscope.pro"
# endif
# include "proto/digraph.pro"
# include "proto/edit.pro"
# include "proto/eval.pro"
# include "proto/ex_cmds.pro"
# include "proto/ex_docmd.pro"
# include "proto/ex_getln.pro"
# include "proto/fileio.pro"
# include "proto/getchar.pro"
# include "proto/main.pro"
# include "proto/mark.pro"
# ifndef MESSAGE_FILE
void
#ifdef __BORLANDC__
_RTLENTRYF
#endif
smsg __ARGS((char_u *, ...));	/* cannot be produced automatically */
void
#ifdef __BORLANDC__
_RTLENTRYF
#endif
smsg_attr __ARGS((int, char_u *, ...));
# endif
# include "proto/memfile.pro"
# include "proto/memline.pro"
# include "proto/message.pro"
# include "proto/misc1.pro"
# include "proto/misc2.pro"
#ifndef HAVE_STRPBRK	    /* not generated automatically from misc2.c */
char_u *vim_strpbrk __ARGS((char_u *s, char_u *charset));
#endif
# ifdef MULTI_BYTE
#  include "proto/multbyte.pro"
# endif
# include "proto/normal.pro"
# include "proto/ops.pro"
# include "proto/option.pro"
# include "proto/quickfix.pro"
# include "proto/regexp.pro"
# include "proto/screen.pro"
# include "proto/search.pro"
# include "proto/syntax.pro"
# include "proto/tag.pro"
# include "proto/term.pro"
# if defined(HAVE_TGETENT) && (defined(AMIGA) || defined(VMS))
#  include "proto/termlib.pro"
# endif
# include "proto/ui.pro"
# include "proto/undo.pro"
# include "proto/version.pro"
# include "proto/window.pro"

# ifdef HAVE_PYTHON
#  include "proto/if_python.pro"
# endif

# ifdef HAVE_TCL
#  include "proto/if_tcl.pro"
# endif

# ifdef USE_GUI
#  include "proto/gui.pro"
#  ifdef USE_GUI_WIN32
#   include "proto/gui_w32.pro"
#   ifdef HAVE_OLE
#    include "proto/if_ole.pro"
#   endif
#  endif
#  ifdef USE_GUI_MOTIF
#   include "proto/gui_motif.pro"
#  endif
#  ifdef USE_GUI_ATHENA
#   include "proto/gui_athena.pro"
#ifdef USE_BROWSE
extern char *vim_SelFile __ARGS((Widget toplevel, char *prompt, char *init_path, int (*show_entry)(), int x, int y, GuiColor fg, GuiColor bg));
#endif
#  endif
#  ifdef USE_GUI_BEOS
#   include "proto/gui_beos.pro"
#  endif
#  ifdef USE_GUI_MAC
#   include "proto/gui_mac.pro"
extern int putenv __ARGS((const char *string));		/* from pty.c */
extern int OpenPTY __ARGS((char **ttyn));		/* from pty.c */
#  endif
#  ifdef USE_GUI_X11
#   include "proto/gui_x11.pro"
extern int OpenPTY __ARGS((char **ttyn));	/* from pty.c */
#  endif
#  if defined(USE_GUI_AMIGA)
#    include "proto/gui_amiga.pro"
#  endif
#  ifdef RISCOS
#   include "proto/gui_riscos.pro"
#  endif
# endif	/* USE_GUI */

/*
 * The perl include files pollute the namespace, therfore proto.h must be
 * included before the perl include files.  But then CV is not defined, which
 * is used in if_perl.pro.  To get around this, the perl prototype files are
 * not included here for the perl files.  Use a dummy define for CV for the
 * other files.
 */
#if defined(HAVE_PERL_INTERP) && !defined(IN_PERL_FILE)
# define CV void
# ifdef __BORLANDC__
#  pragma option -pc
# endif
# include "proto/if_perl.pro"
# ifdef __BORLANDC__
#  pragma option -p.
# endif
# include "proto/if_perlsfio.pro"
#endif

#ifdef __BORLANDC__
# define _PROTO_H
#endif
#endif /* !PROTO && !NOPROTO */
