/*
 * orig_fs.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ꥸʥե륷ƥ
 */


#include"config.h"
#include"types.h"
#include"lib.h"
#include"errno.h"
#include"mm.h"
#include"fs.h"
#include"device.h"
#include"orig_fs.h"


enum{
	BLOCK_SIZE=1024,				/* ֥å */
	MAX_NAME_SIZE=128,				/* ե̾ */
	DIR_SIZE=4096,					/* ǥ쥯ȥꥵ */
	EMPTY_BLOCK_NUM=(BLOCK_SIZE-12)/sizeof(uint),	/* ץƥ֥åΥ֥å */
	INODE_BLOCK_NUM=(BLOCK_SIZE-44)/sizeof(uint),	/* inode֥å */
};


/* Inode */
typedef struct{
	int file_type;				/* File type */
	ushort owner_id;			/* Owner UID */
	ushort group_id;			/* Group ID */
	size_t size;				/* File size by byte */
	uint64 access_time;			/* Last access time */
	uint64 create_time;			/* Create time */
	uint64 modificat_time;		/* Last modification time */
	uint my_secter;				/* my block number */
	uint parent_sect;			/* ƥǥ쥯ȥꥻ */
	uint secter[INODE_BLOCK_NUM];	/* file secter number */
}INODE;

/* Directory top */
typedef struct{
	ushort owner_id;		/* Owner UID */
	ushort group_id;		/* Group ID */
	uint64 access_time;		/* Last access time */
	uint64 create_time;		/* Create time */
	uint64 modificat_time;	/* Last modification time */
	uint my_secter;			/* my block number */
	uint parent_sect;		/* ƥǥ쥯ȥꥻ */
	ushort entry_top;		/* Top direcctory entry offset */
	ushort empty_top;		/* Top empty entry offset */
}DIR;

/* Directory entry */
typedef struct{
	uchar type;					/* File or directory */
	uchar size;					/* entry size */
	uchar low_num;				/* low tree conect entries */
	uchar high_num;				/* high tree conect entries */
	ushort parent;				/* parent entry offset */
	ushort low;					/* low entry offset */
	ushort high;				/* high entry offset */
	uint secter;				/* secter number */
	char name[MAX_NAME_SIZE];	/* Name string */
}DIR_ENT;

/* Directory empty entry */
typedef struct{
	ushort prev;		/* prev empty entry */
	ushort next;		/* next empty entry */
	ushort size;		/* entry size */
}EMPTY_ENT;

/* ֥å */
typedef struct{
	uint prev;						/* prev empty block link */
	uint next;						/* next empty block link */
	int current;					/* ֥åθ */
	uint empty[EMPTY_BLOCK_NUM];	/* ֥å */
}ENPTY_BLOCK;


#define DIR_ENTRY(entry,buf) ((DIR_ENT*)(entry+buf))


static SUPER_BLOCK *super_block[MAX_DEVICE_OPEN];
static ENPTY_BLOCK *empty_file_blk[MAX_DEVICE_OPEN];
static ENPTY_BLOCK *empty_dir_blk[MAX_DEVICE_OPEN];


static DIR_ENT *splay(DIR_ENT*,ushort*,uint);

static uint mount(int);
static int umount(int);
static int open(const char*,int,uint);
static int close(int,uint);
static int read(int,uint,void*,size_t,size_t);
static int write(int,uint,void*,size_t,size_t);
static int ioctr(int,uint,int,void*);
static int rename(int,uint,const char*);
static int creat(const char*,int,uint);
static uint opendir(const char*,int,uint);
static int mkdir(const char*,int,uint);


static FS orig_fs={
	"orig_fs",mount,umount,open,close,read,write,ioctr,rename,creat,opendir,mkdir
};


/************************************************************************************
 *
 * inline functions
 *
 ************************************************************************************/

/*
 * cmpare path strings
 * parameters : Destination string(end='\0'),Sorce string(end='/' or '\0')
 * return : =0 or =1 or =-1;
 */
extern inline int cmppath(const char *path1,const char *path2)
{
	while(*path1++==*path2++)
		if(*(path1-1)=='\0')return 0;

	if((*--path1=='\0')&&(*--path2=='/'))return 0;
	if(*path1<*path2)return 1;

	return -1;
}


/************************************************************************************
 *
 * directory functions
 *
 ************************************************************************************/

/*---------------------------- ʬؿ ---------------------------------------*/

/*
 * search paretnt entry
 * parameters : value,root entyr addoress pointer,directory buffer addres
 * return : parent entry or NULL
 */
DIR_ENT *search_parent(const char *path,ushort *root,uint buf_add)
{
	int r;
	DIR_ENT *p=NULL,*q;


	for(q=DIR_ENTRY(*root,buf_add);q!=(DIR_ENT*)buf_add;)
	{
		p=splay(q,root,buf_add);

		r=cmppath(p->name,path);
		if(r<0)
		{
			q=DIR_ENTRY(p->low,buf_add);
			++p->low_num;
		}
		else if(r>0)
		{
			q=DIR_ENTRY(p->high,buf_add);
			++p->high_num;
		}
		else return NULL;
	};

	return p;
}


/*
 * search same name entry
 * parameters : path,root entry address,directory buffer addres
 * return : same name entry or NULL
 */
DIR_ENT *search_same(const char *path,ushort root,uint buf_add)
{
	int r;
	DIR_ENT *p;


	p=(DIR_ENT*)(root+buf_add);
	while(p!=(DIR_ENT*)buf_add)
	{
		r=cmppath(p->name,path);
		if(r<0)p=DIR_ENTRY(p->low,buf_add);
		else if(r>0)p=DIR_ENTRY(p->high,buf_add);
		else return p;
	}

	return NULL;
}


/*
 * round entry
 * parameters : top entry,root entry address pointer,directory buffer addres
 * return : new top entry
 */
DIR_ENT *round_low(DIR_ENT *top,ushort *root,uint buf_add)
{
	DIR_ENT *p;


	if((p=DIR_ENTRY(top->high,buf_add))==(DIR_ENT*)buf_add)return top;
	if((top->high=p->low)!=0)DIR_ENTRY(p->low,buf_add)->parent=(uint)top-buf_add;
	top->high_num=p->low_num;
	p->low=(uint)top-buf_add;
	p->low_num+=top->low_num+1;
	if((p->parent=top->parent)!=0)
	{
		if(DIR_ENTRY(p->parent,buf_add)->low==(uint)top-buf_add)
			DIR_ENTRY(p->parent,buf_add)->low=(uint)p-buf_add;
		else DIR_ENTRY(p->parent,buf_add)->high=(uint)p-buf_add;
	}
	else *root=(uint)p-buf_add;
	top->parent=(uint)p-buf_add;

	return p;
}

DIR_ENT *round_high(DIR_ENT *top,ushort *root,uint buf_add)
{
	DIR_ENT *p;


	if((p=DIR_ENTRY(top->low,buf_add))==(DIR_ENT*)buf_add)return top;
	if((top->low=p->high)!=0)DIR_ENTRY(p->high,buf_add)->parent=(uint)top-buf_add;
	top->low_num=p->high_num;
	p->high=(uint)top-buf_add;
	p->high_num+=top->high_num+1;
	if((p->parent=top->parent)!=0)
	{
		if(DIR_ENTRY(p->parent,buf_add)->low==(uint)top-buf_add)
			DIR_ENTRY(p->parent,buf_add)->low=(uint)p-buf_add;
		else DIR_ENTRY(p->parent,buf_add)->high=(uint)p-buf_add;
	}
	else *root=(uint)p-buf_add;
	top->parent=(uint)p-buf_add;

	return p;
}


/*
 * ʬ٨ʿؿ
 * ¦Υȥ꡼ȿ¦Υȥ꡼2ܤ¿
 * ¦¦Υȥ꡼¦Υȥ꡼1/2꾯ʤ硢ȿ¦زž롣
 * parameters : top entry,root entry address pointer,directory buffer address
 * return : new top entyr or error=NULL
 */
DIR_ENT *splay(DIR_ENT *top,ushort *root,uint buf_add)
{
	if((top->high_num>top->low_num*2)&&(DIR_ENTRY(top->high,buf_add)->low_num<top->high_num/2))
		return round_low(top,root,buf_add);
	else if((top->low_num>top->high_num*2)&&(DIR_ENTRY(top->low,buf_add)->high_num<top->low_num/2))
		return round_high(top,root,buf_add);

	return top;
}


/*
 * ȥ꡼ξʤزžʬǥȥ꡼򲼹ߤơ󥯤롣
 * parameters : delete path,root entry address pointer,directory buffer address
 * return : delete entry or error=NULL
 */
DIR_ENT *down_and_del(const char *path,ushort *root,uint buf_add)
{
	DIR_ENT *p,*q;


	if((p=search_same(path,*root,buf_add))==NULL)return NULL;

	/* root̤ʤ饨ȥ꡼1ĸ餷Ƥ */
	for(q=p;q->parent!=0;q=DIR_ENTRY(q->parent,buf_add))
	{
		if(DIR_ENTRY(p->parent,buf_add)->low==(uint)q-buf_add)
			--DIR_ENTRY(q->parent,buf_add)->low_num;
		else --DIR_ENTRY(q->parent,buf_add)->high_num;
	}

	/* ߤ롣 */
	while(p->low_num*p->high_num)
	{
		if(p->low_num<p->high_num)--round_low(p,root,buf_add)->low_num;
		else --round_high(p,root,buf_add)->high_num;
	}

	/*  */
	if(p->parent==0)
	{
		*root=(uint)p->low+(uint)p->high;
		if(*root!=0)DIR_ENTRY(*root,buf_add)->parent=0;
	}
	else
	{
		if(DIR_ENTRY(p->parent,buf_add)->low==(uint)p-buf_add)
		{
			DIR_ENTRY(p->parent,buf_add)->low=(uint)p->low+(uint)p->high;
			DIR_ENTRY(p->parent,buf_add)->low_num=p->low_num+p->high_num;
			if(DIR_ENTRY(p->parent,buf_add)->low!=0)
				DIR_ENTRY(DIR_ENTRY(p->parent,buf_add)->low,buf_add)->parent=p->parent;
		}
		else
		{
			DIR_ENTRY(p->parent,buf_add)->high=(uint)p->low+(uint)p->high;
			DIR_ENTRY(p->parent,buf_add)->high_num=p->low_num+p->high_num;
			if(DIR_ENTRY(p->parent,buf_add)->high!=0)
				DIR_ENTRY(DIR_ENTRY(p->parent,buf_add)->low,buf_add)->parent=p->parent;
		}
	}

	return p;
}


/*---------------------------- ؿ ---------------------------------------*/

/*
 * ǸΥǥ쥯ȥΥХåեɤ߹ǡǸΥѥ֤̾
 * parameters : path,directoy address,device inode number
 * return : path or error=NULL
 */
const char *get_last_directory(const char *path,DIR *dir,int din)
{
	return NULL;
}


/*---------------------------- ȥ꡼ɲúؿ ---------------------------------------*/

/*
 * get empty entry
 * parameters : path length,buffer addres
 * return : new entry or error=NULL
 */
DIR_ENT *get_empty_entry(EMPTY_ENT *top,int pathlen,uint buf_add)
{
	enum{MIN_ENT_SIZE=sizeof(DIR_ENT)-(MAX_NAME_SIZE-sizeof(int))};

	int size;
	EMPTY_ENT *p;


	size=ROUNDUP(sizeof(DIR_ENT)-(MAX_NAME_SIZE-pathlen),sizeof(int));
	p=top;
	do
	{
		if(p->size>=size)
		{
			if(p->size-size>=MIN_ENT_SIZE)
			{
				ushort a=(uint)p-buf_add+size;
				EMPTY_ENT *q=(EMPTY_ENT*)((uint)p+size);

				q->next=p->next;
				q->prev=p->prev;
				q->size=p->size-size;
				((EMPTY_ENT*)(p->prev+buf_add))->next=a;
				((EMPTY_ENT*)(p->next+buf_add))->prev=a;
			}
			else
			{
				((EMPTY_ENT*)(p->prev+buf_add))->next=p->next;
				((EMPTY_ENT*)(p->next+buf_add))->prev=p->prev;
			}

			return (DIR_ENT*)p;
		}
	}while((p=(EMPTY_ENT*)(p->next+buf_add))!=top);

	return NULL;
}


/*
 * ǥ쥯ȥꥨȥ꡼ɲä롣
 * פȥʥС̤Ϥ֤
 * parameters : add value,root joint adoress pointer
 * return : directory entry or error=NULL
 */
DIR_ENT *add_entry_to_dir(const char *path,DIR *dir,int din)
{
	return NULL;
}


int del_entry()
{
	return 0;
}


/************************************************************************************
 *
 * Init functions
 *
 ************************************************************************************/

int init_orig_fs()
{
	int i;


	for(i=0;i<MAX_DEVICE_OPEN;++i)
	{
		super_block[i]=NULL;
		empty_file_blk[i]=NULL;
		empty_dir_blk[i]=NULL;
	}

	return regist_fs(&orig_fs);
}


/************************************************************************************
 *
 * System call interface
 *
 ************************************************************************************/

/*
 * parameters : device inode
 * return : root directory block or error=0
 */
uint mount(int din)
{
	void *buf;
	int block;	/* BLOCK_SIZE/secter */


	/* Ǥ˥ޥȤƤ뤫ǧ */
	if(super_block[din]!=NULL)return 0;

	/* Read super block */
	block=BLOCK_SIZE/get_secter_size(din);
	if((buf=kmalloc(BLOCK_SIZE))==NULL)return 0;
	if(read_direct(din,buf,block,SBLOCK_SECTER)!=block)return 0;
	if(((SUPER_BLOCK*)buf)->magic_number!=SBLOCK_MAGIC)return 0;
	super_block[din]=(SUPER_BLOCK*)buf;

	/* Read empty block */
	if((buf=kmalloc(BLOCK_SIZE))==NULL)goto ERR;
	if(read_direct(din,buf,block,super_block[din]->empty_file_blk)!=block)goto ERR;
	empty_file_blk[din]=(ENPTY_BLOCK*)buf;
	if((buf=kmalloc(BLOCK_SIZE))==NULL)goto ERR;
	if(read_direct(din,buf,block,super_block[din]->empty_dir_blk)!=block)goto ERR;
	empty_file_blk[din]=(ENPTY_BLOCK*)buf;

	return super_block[din]->root_blk;

ERR:
	kfree(empty_dir_blk[din]);
	kfree(empty_file_blk[din]);
	kfree(super_block[din]);

	return 0;
}


/*
 * parameters : device inode
 * return : 0 or error=-1
 */
int umount(int din)
{
	return 0;
}


/*
 * parameters : path,device inode,directory block
 * return : inode block or error=-1
 */
int open(const char *path,int din,uint dir)
{
	return 0;
}


/*
 * parameters : device inode,inode block
 * return : 0 or error=-1
 */
int close(int din,uint inode)
{
	return 0;
}


int read(int din,uint inode,void *buf,size_t size,size_t begnin)
{
	return 0;
}


int write(int din,uint inode,void *buf,size_t size,size_t begin)
{
	return 0;
}


int ioctr(int din,uint inode,int cmd,void *param)
{
	return 0;
}


int rename(int din,uint inode,const char *name)
{
	return 0;
}


int creat(const char *path,int din,uint dir)
{
	return 0;
}


uint opendir(const char *path,int din,uint dir)
{
	return 0;
}


int mkdir(const char *path,int din,uint dir)
{
	return 0;
}
