/*
 * pci.h (C) 2002 Minoru Murashima
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * PCI
 */


#ifndef pci_h
#define pci_h


#ifndef ASM_FILE


#include"types.h"


enum{
	/* Config register */
	PCI_CONF_VEND=0,
	PCI_CONF_COM=4,
	PCI_CONF_CLS=9,

	/* Class coad,base+sub */
	PCI_CLS_IDE=0x101,		/* IDE */

	/* Command register bit */
	PCI_COM_BM_BIT=0x4,		/* Bus Master enable */
};


typedef struct{
	uint vender;
	int bus;
	int dev;
	int func;
}PCI_INFO;


extern uint read_pci_config(int,int,int,int);
extern void writedw_pci_config(int,int,int,int,uint);
extern void writew_pci_config(int,int,int,int,ushort);
extern void writeb_pci_config(int,int,int,int,uchar);
extern int search_pci_class(int,PCI_INFO*);


#endif


#endif
