﻿Imports System.Xml
Imports System.IO

Namespace Model

    Module GlobalValues

#If DEBUG Then
        Public Const APPLICATION_PATH As String = "\..\..\..\.."
#Else
        Public Const APPLICATION_PATH As String = "\.."
#End If

        Public Const BUTTON_SETTING As String = "LauncherButton.xml"

        Public Const SETTING_PARAM As String = "LauncherSetting.xml"

        Private mFolder() As DirectoryInfo

        Private mButtonSize As Integer

        Private mIconSize As Integer

        Private mStrTabele As Dictionary(Of String, String)

        Private mButtonList As Dictionary(Of String, LauncherButton)

        Private mPageList As SortedList(Of String, LauncherPage)

        Private mCurrent As LauncherPage

        Private mSrcImage As Bitmap

        Public Sub ReadApplicationFolder()
            Dim hpath As String = System.Environment.GetEnvironmentVariable("USERPROFILE")

            mFolder = New DirectoryInfo() { _
                New DirectoryInfo(hpath & "\.7Launcher"), _
                New DirectoryInfo(hpath & "\.7Launcher\link"), _
                New DirectoryInfo(hpath & "\.7Launcher\setting") _
            }
        End Sub

        Public Sub ReadLauncherButtons()
            Try
                Dim doc = New XmlDocument
                doc.Load(AppSetting.FullName & "\" & BUTTON_SETTING)

                Dim lst = New List(Of LauncherButton)
                For Each nd As XmlNode In doc.SelectNodes("/Buttons/Button")
                    LauncherButton.CreateButtonData(lst, nd)
                Next

                mButtonList = New Dictionary(Of String, LauncherButton)
                For Each btn As LauncherButton In lst
                    mButtonList.Add(btn.Name, btn)
                Next

            Catch ex As Exception
                Throw New ApplicationException("Application read launcer button info error!")
            End Try
        End Sub

        Public Sub ReadLauncherSetting()
            Try
                Dim doc = New XmlDocument
                doc.Load(AppSetting.FullName & "\" & SETTING_PARAM)

                With doc.SelectSingleNode("/Setting")
                    mButtonSize = Integer.Parse(.SelectSingleNode("ButtonSize").InnerText)
                    mIconSize = Integer.Parse(.SelectSingleNode("IconSize").InnerText)
                End With

                Dim lst = New List(Of LauncherPage)
                For Each nd As XmlNode In doc.SelectNodes("/Setting/Page")
                    LauncherPage.CreatePageData(lst, nd, mButtonList)
                Next

                mPageList = New SortedList(Of String, LauncherPage)
                For Each page As LauncherPage In lst
                    mPageList.Add(page.Name, page)
                Next

                mSrcImage = New Bitmap(mButtonSize, mButtonSize)
                With Graphics.FromImage(mSrcImage)
                    Dim img As Image = Image.FromFile("data\skins\select_fram.png")
                    .SmoothingMode = Drawing2D.SmoothingMode.HighQuality
                    .DrawImage(img, 2, 2, mButtonSize - 5, mButtonSize - 5)
                    img.Dispose()
                    .Dispose()
                End With

            Catch ex As Exception
                Throw New ApplicationException("Application read setting error!")
            End Try
        End Sub

#Region "properties"

        Public ReadOnly Property AppDirectory() As DirectoryInfo
            Get
                Return mFolder(0)
            End Get
        End Property

        Public ReadOnly Property AppLinks() As DirectoryInfo
            Get
                Return mFolder(1)
            End Get
        End Property

        Public ReadOnly Property AppSetting() As DirectoryInfo
            Get
                Return mFolder(2)
            End Get
        End Property

        Public ReadOnly Property ButtonSize() As Integer
            Get
                Return mButtonSize
            End Get
        End Property

        Public ReadOnly Property IconSize() As Integer
            Get
                Return mIconSize
            End Get
        End Property

        Public ReadOnly Property Page(ByVal name As String) As LauncherPage
            Get
                If mPageList.ContainsKey(name) Then
                    Return mPageList(name)
                Else
                    Return Nothing
                End If
            End Get
        End Property

        Public ReadOnly Property Pages() As IList(Of LauncherPage)
            Get
                Return mPageList.Values
            End Get
        End Property

        Public Property CurrentPage() As LauncherPage
            Get
                Return mCurrent
            End Get
            Set(ByVal value As LauncherPage)
                mCurrent = value
            End Set
        End Property

        Public ReadOnly Property SelectFrame() As Image
            Get
                Return mSrcImage
            End Get
        End Property

#End Region

    End Module

End Namespace


