﻿Imports System.Xml

Namespace Model

    Public NotInheritable Class LauncherPage

        Public Shared Sub CreatePageData(ByVal pageList As List(Of LauncherPage), _
                                         ByVal pageTag As XmlNode, _
                                         ByVal buttons As Dictionary(Of String, LauncherButton))
            Dim other = New LauncherPage(pageTag)
            Dim x As Integer = 0, y As Integer = 0
            Dim nm As String

            With other
                For Each row As XmlNode In pageTag.SelectNodes("Row")
                    x = 0
                    For Each cln As XmlNode In row.SelectNodes("Column")
                        nm = cln.InnerText.Trim()
                        If buttons.ContainsKey(nm) AndAlso _
                           x < .mXCount AndAlso y < .mYCount Then
                            .mCell(x, y) = buttons(nm)
                        End If
                        x += 1
                    Next
                    y += 1
                Next
            End With
            pageList.Add(other)
        End Sub

        Private mName As String

        Private mTitle As String

        Private mXCount As Integer, mYCount As Integer

        Private mCell(,) As LauncherButton

        Private Sub New(ByVal pageTag As XmlNode)
            With pageTag
                mName = .Attributes("Name").Value.Trim()

                mXCount = Integer.Parse(.Attributes("X_cnt").Value)
                If mXCount < 1 Then mXCount = 1
                mYCount = Integer.Parse(.Attributes("Y_cnt").Value)
                If mYCount < 1 Then mYCount = 1

                mTitle = .Attributes("Title").Value.Trim()

                mCell = New LauncherButton(mXCount - 1, mYCount - 1) {}
            End With
        End Sub

#Region "properties"

        Public ReadOnly Property Name() As String
            Get
                Return mName
            End Get
        End Property

        Public ReadOnly Property ColumnCt() As Integer
            Get
                Return mXCount
            End Get
        End Property

        Public ReadOnly Property RowCt() As Integer
            Get
                Return mYCount
            End Get
        End Property

        Public ReadOnly Property Title() As String
            Get
                Return mTitle
            End Get
        End Property

        Default Public ReadOnly Property items(ByVal x As Integer, _
                                               ByVal y As Integer) As LauncherButton
            Get
                If x < mXCount AndAlso y < mYCount Then
                    Return mCell(x, y)
                Else
                    Return Nothing
                End If
            End Get
        End Property

#End Region

    End Class

End Namespace