﻿Imports System.Runtime.InteropServices

Namespace Model

    Public Module Win32

        Public Const ILC_COLOR As Integer = 0
        Public Const ILC_MASK As Integer = 2

        Public Const SHIL_EXTRALARGE As Integer = 2

        Public Const SHGFI_ICON As Integer = &H100              ' アイコン・リソースの取得
        Public Const SHGFI_DISPLAYNAME As Integer = &H200       ' get display name
        Public Const SHGFI_TYPENAME As Integer = &H400          ' get type name
        Public Const SHGFI_ATTRIBUTES As Integer = &H800        ' get attributes
        Public Const SHGFI_ICONLOCATION As Integer = &H1000     ' get icon location
        Public Const SHGFI_EXETYPE As Integer = &H2000          ' return exe type
        Public Const SHGFI_SYSICONINDEX As Integer = &H4000     ' get system icon index
        Public Const SHGFI_LINKOVERLAY As Integer = &H8000      ' put a link overlay on icon
        Public Const SHGFI_SELECTED As Integer = &H10000        ' show icon in selected state
        Public Const SHGFI_ATTR_SPECIFIED As Integer = &H20000  ' get only specified attributes
        Public Const SHGFI_LARGEICON As Integer = &H0           ' 大きいアイコン
        Public Const SHGFI_SMALLICON As Integer = &H1           ' 小さいアイコン
        Public Const SHGFI_OPENICON As Integer = &H2            ' get open icon
        Public Const SHGFI_SHELLICONSIZE As Integer = &H4       ' get shell size icon
        Public Const SHGFI_PIDL As Integer = &H8                ' pszPath is a pidl
        Public Const SHGFI_USEFILEATTRIBUTES As Integer = &H10  ' use passed dwFileAttribute
        Public Const SHGFI_ADDOVERLAYS As Integer = &H20        ' apply the appropriate overlays
        Public Const SHGFI_OVERLAYINDEX As Integer = &H40       ' Get the index of the overlay in the upper 8 bits of the iIcon

        <StructLayout(LayoutKind.Sequential)> _
        Public Structure SHFILEINFO
            Public hIcon As IntPtr
            Public iIcon As IntPtr
            Public dwAttributes As Integer
            <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=256)> _
            Public szDisplayName As String
            <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=80)> _
            Public szTypeName As String
        End Structure

        <StructLayout(LayoutKind.Sequential)> _
        Public Structure DWM_BLURBEHIND
            Public dwFlags As Integer
            Public fEnable As Integer
            Public hRgnBlur As IntPtr
            Public fTransitionOnMaximized As Integer
        End Structure

        <StructLayout(LayoutKind.Sequential)> _
        Public Structure MARGINS
            Public cxLeftWidth As Integer
            Public cxRightWidth As Integer
            Public cyTopHeight As Integer
            Public cyBottomHeight As Integer

            Public Sub New(ByVal left As Integer, ByVal right As Integer, _
                           ByVal top As Integer, ByVal bottom As Integer)
                Me.cxLeftWidth = left
                Me.cxRightWidth = right
                Me.cyTopHeight = top
                Me.cyBottomHeight = bottom
            End Sub
        End Structure

        <StructLayout(LayoutKind.Sequential)> _
        Public Structure RECT
            Public Left As Integer
            Public Top As Integer
            Public Right As Integer
            Public Bottom As Integer
        End Structure

    End Module

End Namespace