﻿Imports System.IO
Imports Launcher7.Model
Imports System.Runtime.InteropServices

Namespace Views

    Public NotInheritable Class GridFrame

#Region "events"

        Public Event DropFile(ByVal send As Object, _
                              ByVal drgevent As DragEventArgs, _
                              ByVal filePath As String, _
                              ByVal x As Integer, ByVal y As Integer)

        Public Event ClickGrid(ByVal send As Object, _
                               ByVal x As Integer, ByVal y As Integer)

        Public Event DeleteLink(ByVal send As Object, _
                                ByVal x As Integer, ByVal y As Integer)

#End Region

        Private mBorder As Pen

        Private mButtonInfo

        Private mItemRec As List(Of List(Of Rectangle))

        Private mousePos As Point

        Public Sub New()
            InitializeComponent()

            mItemRec = New List(Of List(Of Rectangle))
            mBorder = New Pen(Color.DarkBlue, 2)

            Me.SetStyle(ControlStyles.OptimizedDoubleBuffer, True)

            DivisionArea()
        End Sub

        Protected Overrides Sub OnPaint(ByVal e As PaintEventArgs)
            MyBase.OnPaint(e)

            With e.Graphics
                For i As Integer = 0 To mItemRec.Count - 1
                    For j As Integer = 0 To mItemRec(i).Count - 1
                        Dim info As AdjustButton = CType(Me.Parent.Parent, MakeForm).AdjustButtonCell(j, i)

                        If info IsNot Nothing Then
                            .DrawImage(info.IconImage, mItemRec(i)(j))
                        End If

                        .DrawRectangle(mBorder, mItemRec(i)(j))
                    Next
                Next
            End With
        End Sub

        Protected Overrides Sub OnMouseDown(ByVal e As MouseEventArgs)
            MyBase.OnMouseDown(e)
            If e.Button = MouseButtons.Left Then
                For i As Integer = 0 To mItemRec.Count - 1
                    For j As Integer = 0 To mItemRec(i).Count - 1
                        If mItemRec(i)(j).Contains(e.Location) Then
                            mousePos = New Point(j, i)
                        End If
                    Next
                Next
            Else
                mousePos = New Point(-1, -1)
            End If
        End Sub

        Protected Overrides Sub OnMouseUp(ByVal e As MouseEventArgs)
            MyBase.OnMouseUp(e)
            mousePos = New Point(-1, -1)
        End Sub

        Protected Overrides Sub OnMouseMove(ByVal e As MouseEventArgs)
            MyBase.OnMouseMove(e)
            If e.Button = MouseButtons.Left Then
                RaiseEvent DeleteLink(Me, mousePos.X, mousePos.Y)
                Me.Invalidate()
            End If
        End Sub

        Protected Overrides Sub OnDragEnter(ByVal drgevent As DragEventArgs)
            With drgevent
                .Effect = DragDropEffects.None

                If .Data.GetDataPresent(DataFormats.FileDrop) Then
                    Dim drags() As String = .Data.GetData(DataFormats.FileDrop)
                    Dim finfo As FileInfo = New FileInfo(drags(0))

                    If finfo.Extension = ".lnk" OrElse finfo.Extension = ".exe" Then
                        .Effect = DragDropEffects.Copy
                    End If
                End If
            End With
            MyBase.OnDragEnter(drgevent)
        End Sub

        Protected Overrides Sub OnDragDrop(ByVal drgevent As DragEventArgs)
            With drgevent
                If .Data.GetDataPresent(DataFormats.FileDrop) Then
                    Dim drags() As String = .Data.GetData(DataFormats.FileDrop)
                    Dim finfo As FileInfo = New FileInfo(drags(0))

                    If finfo.Extension = ".lnk" OrElse finfo.Extension = ".exe" Then
                        Dim mpos As Point = Me.PointToClient(Control.MousePosition)
                        For i As Integer = 0 To mItemRec.Count - 1
                            For j As Integer = 0 To mItemRec(i).Count - 1
                                If mItemRec(i)(j).Contains(mpos) Then
                                    RaiseEvent DropFile(Me, drgevent, finfo.FullName, j, i)
                                End If
                            Next
                        Next
                    End If
                End If
            End With
            MyBase.OnDragDrop(drgevent)
        End Sub

        Protected Overrides Sub OnSizeChanged(ByVal e As EventArgs)
            MyBase.OnSizeChanged(e)
            DivisionArea()
            Me.Invalidate()
        End Sub

        Protected Overrides Sub OnMouseClick(ByVal e As MouseEventArgs)
            MyBase.OnMouseClick(e)
            Dim mpos As Point = Me.PointToClient(Control.MousePosition)
            For i As Integer = 0 To mItemRec.Count - 1
                For j As Integer = 0 To mItemRec(i).Count - 1
                    If mItemRec(i)(j).Contains(mpos) Then
                        RaiseEvent ClickGrid(Me, j, i)
                        Me.Invalidate()
                        Return
                    End If
                Next
            Next
        End Sub

#Region ""

        Private Sub DivisionArea()
            If Model.ButtonSize > 0 Then
                Dim lf As Integer, wct As Integer
                wct = Math.DivRem(Me.Width - 10, Model.ButtonSize, lf)

                Dim tp As Integer, hct As Integer
                hct = Math.DivRem(Me.Height - 10, Model.ButtonSize, tp)

                mItemRec.Clear()

                For j As Integer = 0 To hct - 1
                    mItemRec.Add(New List(Of Rectangle))
                    For i As Integer = 0 To wct - 1
                        mItemRec(j).Add(New Rectangle(lf \ 2 + 5 + Model.ButtonSize * i, _
                                                      tp \ 2 + 5 + Model.ButtonSize * j, _
                                                      Model.ButtonSize, Model.ButtonSize))
                    Next
                Next
            End If
        End Sub

#End Region

    End Class

End Namespace
