﻿Imports Launcher7.Model
Imports System.Runtime.InteropServices

Namespace Views

    Public NotInheritable Class ButtonFrame

#Region "Win32 API"

        <DllImport("dwmapi.dll")> _
        Private Shared Function DwmIsCompositionEnabled(ByRef pfEnabled As Integer) As Integer
        End Function

        <DllImport("dwmapi.dll")> _
        Private Shared Function DwmEnableBlurBehindWindow(ByVal hwnd As IntPtr, ByRef pBlurBehind As DWM_BLURBEHIND) As Integer
        End Function

        <DllImport("dwmapi.dll")> _
        Private Shared Function DwmExtendFrameIntoClientArea(ByVal hdc As IntPtr, ByRef marInset As MARGINS) As Integer
        End Function

        <DllImport("user32.dll")> _
        Private Shared Function FindWindow(ByVal lpClassName As String, ByVal lpWindowName As String) As IntPtr
        End Function

        <DllImport("user32.dll")> _
        Private Shared Function GetWindowRect(ByVal hwnd As IntPtr, ByRef lpRect As Win32.RECT) As Integer
        End Function

#End Region

        Private prevButton As GlassButton

        Private glassBtn(,) As GlassButton

        Public Sub New()
            InitializeComponent()
        End Sub

        Protected Overrides Sub OnLoad(ByVal e As EventArgs)
            MyBase.OnLoad(e)

            GlassSetting()

            SettingResorce(Model.CurrentPage)
            FrameLocationSetting(Me)
        End Sub

#Region "load initialize"

        Private Sub FrameLocationSetting(ByVal moveForm As Form)
            Dim hwnd As IntPtr = FindWindow("Shell_TrayWnd", String.Empty)
            Dim rec = New Win32.RECT
            GetWindowRect(hwnd, rec)

            Dim w As Integer, h As Integer
            With Screen.PrimaryScreen.Bounds
                If rec.Left = 0 AndAlso rec.Right = .Right Then
                    w = Control.MousePosition.X - moveForm.Width \ 2

                    If w < .Left Then w = 0
                    If w + moveForm.Width > .Right Then w = .Right - moveForm.Width
                    If rec.Top = 0 Then
                        h = rec.Bottom + 5
                    Else
                        h = rec.Top - moveForm.Height - 5
                    End If
                Else
                    h = Control.MousePosition.Y - moveForm.Height \ 2

                    If h < .Top Then h = 0
                    If h + moveForm.Height > .Bottom Then h = .Bottom - moveForm.Height
                    If rec.Left = 0 Then
                        w = rec.Right + 5
                    Else
                        w = rec.Left - moveForm.Width - 5
                    End If
                End If

                moveForm.Location = New Point(w, h)
            End With
        End Sub

        Private Sub SettingResorce(ByVal pPage As LauncherPage)
            Me.Text = pPage.Title

            Me.ClientSize = New Size(pPage.ColumnCt * Model.ButtonSize, _
                                     pPage.RowCt * Model.ButtonSize)

            glassBtn = New GlassButton(pPage.ColumnCt - 1, pPage.RowCt - 1) {}
            For j As Integer = 0 To pPage.RowCt - 1
                For i As Integer = 0 To pPage.ColumnCt - 1
                    If pPage(i, j) IsNot Nothing Then
                        glassBtn(i, j) = New GlassButton(pPage(i, j))
                    End If
                Next
            Next
        End Sub

#End Region

        Protected Overrides Sub OnPaint(ByVal e As PaintEventArgs)
            MyBase.OnPaint(e)

            Dim pos As Point = Me.PointToClient(Control.MousePosition)

            For j As Integer = 0 To glassBtn.GetLength(1) - 1
                For i As Integer = 0 To glassBtn.GetLength(0) - 1
                    If glassBtn(i, j) IsNot Nothing Then
                        PaintButton(e, pos, i, j)
                    End If
                Next
            Next

            GlassSetting()
        End Sub

#Region "paint sub methods"

        Private Sub PaintButton(ByVal e As PaintEventArgs, ByVal pos As Point, ByVal i As Integer, ByVal j As Integer)
            Dim rec As Rectangle = New Rectangle(i * Model.ButtonSize, j * Model.ButtonSize, _
                                                 Model.ButtonSize - 1, Model.ButtonSize - 1)

            If Me.Focused AndAlso rec.Contains(pos) Then
                glassBtn(i, j).FocusDraw(e.Graphics, pos, i, j)

                If prevButton IsNot glassBtn(i, j) Then
                    prevButton = glassBtn(i, j)
                    Me.msgToolTip.Show(glassBtn(i, j).Title, Me, i * Model.ButtonSize, (j + 1) * Model.ButtonSize + 24)
                End If
            Else
                glassBtn(i, j).NonFocusDraw(e.Graphics, i, j)
            End If
        End Sub

#End Region

        Private Sub GlassSetting()
            If System.Environment.OSVersion.Version.Major < 6 Then Return

            Dim enable As Integer
            DwmIsCompositionEnabled(enable)

            If enable = 1 Then
                Dim margin = New MARGINS(0, 0, 0, 0)
                DwmExtendFrameIntoClientArea(Me.Handle, margin)

                Dim bb = New DWM_BLURBEHIND
                bb.dwFlags = 1
                bb.fEnable = 1
                DwmEnableBlurBehindWindow(Me.Handle, bb)
            End If
        End Sub

#Region "mouse events"

        Protected Overrides Sub OnMouseMove(ByVal e As MouseEventArgs)
            MyBase.OnMouseMove(e)
            Me.Invalidate()
        End Sub

        Protected Overrides Sub OnMouseLeave(ByVal e As EventArgs)
            MyBase.OnMouseLeave(e)
            Me.Invalidate()
        End Sub

        Protected Overrides Sub OnMouseDown(ByVal e As System.Windows.Forms.MouseEventArgs)
            MyBase.OnMouseDown(e)

            RemoveHandler Me.LostFocus, AddressOf ButtonFrame_LostFocus

            Dim x As Integer = e.X \ Model.ButtonSize
            Dim y As Integer = e.Y \ Model.ButtonSize

            If x >= 0 AndAlso x < glassBtn.GetLength(0) AndAlso _
               y >= 0 AndAlso y < glassBtn.GetLength(1) AndAlso _
               glassBtn(x, y) IsNot Nothing Then

                Try
                    Dim proc = New Process()
                    Dim btn As GlassButton = glassBtn(x, y)
                    With proc.StartInfo
                        .FileName = btn.LinkPath
                        .Arguments = btn.Argument
                        .WorkingDirectory = btn.WorkPath
                        If btn.Privilege = "Administrator" Then .Verb = "runas"
                    End With
                    proc.Start()

                Catch ex As Exception
                    MessageBox.Show(ex.Message)
                End Try

                Me.Invalidate()
            End If

            AddHandler Me.LostFocus, AddressOf ButtonFrame_LostFocus
        End Sub

#End Region

        Private Sub ButtonFrame_LostFocus(ByVal sender As Object, _
                                          ByVal e As EventArgs) Handles Me.LostFocus
            Application.Exit()
        End Sub

    End Class

End Namespace

