/**
 *  HttpRequestUtils
 *  
 *  @author   $Author: mumincacao $
 *  @version  $Name:  $ $RCSfile: httpRequestUtils.js,v $ $Revision: 1.1 $ $Date: 2006/11/07 01:41:28 $
 * 
 *  @requires XMLHttpRequest / ActiveXObject
 *  @requires DomUtils
**/
var HttpRequestUtils =
{
 /**
  *  init
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 init : function()
 {
  if(typeof XMLHttpRequest == 'undefined' && typeof ActiveXObject == 'function')
  {
   XMLHttpRequest = function()
   {
    var obj = this;
    var ps  = ['readyState','status','statusText','responseText','responseXML'];
    try
    {
     this.nativeObject = new ActiveXObject('Msxml2.XMLHTTP');
    }
    catch(e)
    {
     this.nativeObject = new ActiveXObject('Microsoft.XMLHTTP');
    }
    this.readyState                      = 0;
    this.onreadystatechange              = function(){};
    this.nativeObject.onreadystatechange = function()
    {
     for(var p in ps)
      try
      {
       obj[ps[p]] = obj.nativeObject[ps[p]];
      }
      catch(e)
      {
      }
     obj.onreadystatechange();
    };
   }
   var ms = ['open','setRequestHeader','getResponseHeader','getAllResponseHeader','send','abort'];
   for(var m in ms)
    HttpRequestUtils.setMethod(ms[m]);
  }
 },

 /**
  *  setMethod
  * 
  *  @param   string  nam   // methodName
  * 
  *  @return  void
 **/
 setMethod : function(nam)
 {
  XMLHttpRequest.prototype[nam] = function()
  {
   var args = new Array();
   for(var i = 0;i < arguments.length;i++)
    args[i] = 'args_' + i;
   return Function(args.join(','),'return this.nativeObject.' + nam + '(' + args.join(',') + ')').apply(this,arguments);
  };
 },

 /**
  *  getClient
  *  
  *  @param   string  mod   // methodMode
  *  @param   string  adr   // targetAddress
  *  
  *  @return  HttpRequestObject
 **/
 getClient : function(mod,adr)
 {
  var cli = null;
  try
  {
   cli = new XMLHttpRequest();
  }
  catch(e)
  {
   cli = null;
  }
  if(cli != null)
  {
   cli.open(mod,adr);
   cli.setRequestHeader('content-type','application/x-www-form-urlencoded; charset=UTF-8');
   cli.callbacks = {'unknown' : HttpRequestUtils.isUnknown};
   cli.onreadystatechange = function()
   {
    if(cli.readyState == 4)
    {
     var res = {'txt' : cli.responseText,'xml' : cli.responseXML};
     try
     {
      cli.callbacks[cli.status.toString()](res);
     }
     catch(e)
     {
      cli.callbacks['unknown'](res);
     }
    }
   }
  }
  return cli;
 },

 /**
  *  encodeString
  * 
  *  @param   array  val
  * 
  *  @return  string
 **/
 encodeString : function(val)
 {
  var arr = new Array();
  for(k in val)
   arr.push(k + '=' + encodeURIComponent(val[k]));
  return arr.join('&');
 },

 /**
  *  parseJson
  * 
  *  @param   string  txt
  * 
  *  @return  object
 **/
 parseJson : function(txt)
 {
  return eval('(' + txt + ')');
 },

 /**
  *  isUnknown
  *
  *  @param   array  res {'txt','xml'}
  *  
  *  @return  void
 **/
 isUnknown : function(res)
 {
 }
};

DomUtils.appendEvent(window,'load',HttpRequestUtils.init,'first');
