/**
 *  mLanguage
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name:  $ $RCSfile: language.js,v $ $Revision: 1.3 $ $Date: 2006/11/10 08:30:13 $
 * 
 *  @requires  mController
 *  @requires  mUtils
 *  @member    mUtils
**/
{
 /**
  *  system language data object
  * 
  *  @private
 **/
 this._systemData = {};

 /**
  *  language data object
  * 
  *  @private
 **/
 this._langData = {};

 /**
  *  custom language data object
  * 
  *  @private
 **/
 this._customData = {};

 /**
  *  init
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.init = function()
 {
  this._loadLanguage();
 };

 /**
  *  _loadLanguage
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mUtils#_setupLanguage
  *  @private
 **/
 this._loadLanguage = function()
 {
  var config = mUtils.config;
  var file   = config.getConfig('sysLangPath') + config.getConfig('language') + '/system.js';
  try
  {
   mUtils.loadFile(file);
   mUtils.waitResponse(this,{'_systemData' : file},this._setupLanguage,null);
  }
  catch(e)
  {
   mUtils.logger.setMessage('critical','mLanguage','load system language',e);
  }
 };

 /**
  *  _setupLanguage
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @private
 **/
 this._setupLanguage = function()
 {
 };

 /**
  *  resetLanguage
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.resetLanguage = function()
 {
  this._customData = {};
 };

 /**
  *  getLanguage
  * 
  *  @param   string  keyName
  * 
  *  @return  string
 **/
 this.getLanguage = function(keyName)
 {
  switch(true)
  {
   case this._customData[keyName] != undefined:
    return this._customData[keyName];
   case this._langData[keyName] != undefined:
    return this._langData[keyName];
   case this._systemData[keyName] != undefined:
    return this._systemData[keyName];
   default:
    mUtils.logger.setMessage('notice','mLanguage','get language string',keyName + mUtils.language.getLanguage('mLanguageUndefined'));
    return null;
  }
 };
};
