/**
 *  @package  mValidate methods
 * 
 *  @author   $Author$
 *  @version  $Name$ $RCSfile$ $Revision$ $Date$
 * 
 *  @requires  mUtils
 *  @member    mUtils
**/
{
 /**
  *  mRequireValidator
  * 
  *  @param   string  data
  *  @param   object  params
  * 
  *  @return  bool
 **/
 this.mRequireValidator = function(data,params)
 {
  return data;
 };

 /**
  *  mMinLengthValidator
  * 
  *  @param   string  data
  *  @param   object  params
  * 
  *  @return  bool
 **/
 this.mMinLengthValidator = function(data,params)
 {
  return data.length >= params.minlength
 };

 /**
  *  mMaxLengthValidator
  * 
  *  @param   string  data
  *  @param   object  params
  * 
  *  @return  bool
 **/
 this.mMaxLengthValidator = function(data,params)
 {
  return data.length <= params.maxlength
 };

 /**
  *  mLengthValidator
  * 
  *  @param   string  data
  *  @param   object  params
  * 
  *  @return  bool
 **/
 this.mLengthRangeValidator = function(data,params)
 {
  return data.length >= params.minlength && data.length <= params.length;
 };

 /**
  *  mMinValueValidator
  * 
  *  @param   string  data
  *  @param   object  params
  * 
  *  @return  bool
 **/
 this.mMinValueValidator = function(data,params)
 {
  return perseInt(data) <= perseInt(params.min);
 };

 /**
  *  mMaxValueValidator
  * 
  *  @param   string  data
  *  @param   object  params
  * 
  *  @return  bool
 **/
 this.mMaxValueValidator = function(data,params)
 {
  return perseInt(data) >= perseInt(params.max);
 };

 /**
  *  mValueRangeValidator
  * 
  *  @param   string  data
  *  @param   object  params
  * 
  *  @return  bool
 **/
 this.mValueRangeValidator = function(data,params)
 {
  return perseInt(data) <= perseInt(params.min) && perseInt(data) >= perseInt(params.max);
 };

 /**
  *  mAlphabetValidate
  * 
  *  @param   string  data
  *  @param   object  params
  * 
  *  @return  bool
 **/
 this.mAlphabetValidate = function(data,params)
 {
  return data.match(/^[a-zA-Z]*$/);
 };

 /**
  *  mMaskValidator
  * 
  *  @param   string  data
  *  @param   object  params
  * 
  *  @return  bool
 **/
 this.mMaskValidator = function(data,params)
 {
  var reg = new RegExp(params.mask,params.maskflag);
  return data.match(reg);
 };

 /**
  *  mFilterValidator
  * 
  *  @param   string  data
  *  @param   object  params
  * 
  *  @return  bool
 **/
 this.mFilterValidator = function(data,params)
 {
  var reg = new RegExp(params.filter,params.filterflag);
  return !data.match(reg);
 };
};
