<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
	require("../tools/__include-common-code-file.php");
	if (!defined("LIST_URL_DEFAULT_FOLDER_index")) {
		define("LIST_URL_DEFAULT_FOLDER_index", "C:/Users/Public/Favorites");
	}
	if ($_SESSION['システム管理者'] <> "YES") {
		exit;
	}
	html_header(HTML_TITLE, "_add_header-list-url.php");
	page_header();
	contents_header();
	main_proc();
	page_footer();
	html_footer();
	exit();
function main_proc() {
	if ($_POST['path'].'' <> '') {
		$open_path = form_str_filepath($_POST['path']);
	} elseif ($_GET['path'].'' <> '') {
		$open_path = my_GET('path');
	} elseif ($_SESSION['index_list_url_path'] <> '') {
		$open_path = $_SESSION['index_list_url_path'];
	} else {
		$open_path = LIST_URL_DEFAULT_FOLDER_index;
	}
	$open_path = str_replace(DIRECTORY_SEPARATOR, "/", right_slash_strip($open_path));
	$_SESSION['index_list_url_path'] = $open_path;
	if (isset($_POST['search_key']) && $_POST['search_key'].'' <> '') {
		$_SESSION['index_list_url_search_key'] = $_POST['search_key'];
	} elseif ($_GET['key'].'' <> '') {
		$_SESSION['index_list_url_search_key'] = $_GET['key'];
	}
	if (isset($_POST['search_reset'])) {
		$_SESSION['index_list_url_search_key'] = '';
	}
	if ($_GET['sort'].'' <> '') {
		$_SESSION['index_list_url_sort'] = $_GET['sort'];
	}
	if ($_GET['order'].'' <> '') {
		$_SESSION['index_list_url_sort_order'] = $_GET['order'];
	}
	$file_mode = folder_check($open_path, $path_SJIS, $error_msg);
?>
<div id="header">
	<form name="form0" action="<?= $_SERVER['SCRIPT_NAME'] ?>?type=<?= $_GET['type'] ?>" method="post">
		<input type="button" name="" value="↑" onClick="location.href='<?= $_SERVER['SCRIPT_NAME'] ?>?path=<?= urlencode(up_folder_path($open_path)) ?>'">
		<input class="text" type="text" id="path" name="path" value="<?= my_htmlspecialchars($open_path) ?>" size=100>
		<input type="submit" name="path_change" value="変更"><br>
		<p id="file_name_box">フォルダ：<span><?= up_folder_direct('?path=', $open_path) ?></span></p>
		タイトル/フォルダ名：<input class="text<?= $_SESSION['index_list_url_search_key'] <> '' ? ' list_filter_true' : '' ?>" type="text" name="search_key" value="<?= my_htmlspecialchars($_SESSION['index_list_url_search_key']) ?>" size=30>
		<input type="submit" name="search" value="検索">
		<input type="submit" name="search_reset" value="リセット">
		<label><input type="checkbox" value="on" onClick="ListSubdirOnOff(this)"<?= $_COOKIE['index_list_url_subdir'] == 'on' ? ' checked' : '' ?>>サブディレクトリ検索</label>
<script language="JavaScript">
function ListSubdirOnOff(chk){
	if (chk.checked == true) {
		$.cookie("index_list_url_subdir","on",{ expires: 365 });
	} else {
		$.cookie("index_list_url_subdir","",{ expires: 365 });
	}
	window.location.href = "?";
}
function CheckboxThumbnail(onOff) {
	if (onOff == 'on') {
		$.cookie("index_list_url_thumb","",{ expires: 365 });
	} else {
		$.cookie("index_list_url_thumb","on",{ expires: 365 });
	}
	window.location.href = "?";
}
function ListCaptureOnOff(chk){
	if (chk.checked == true) {
		$.cookie("index_list_url_capture","none",{ expires: 365 });
	} else {
		$.cookie("index_list_url_capture","",{ expires: 365 });
	}
	window.location.href = "?";
}
</script>
	<label><input type="checkbox" value="on" onClick="CheckboxThumbnail('<?= $_COOKIE['index_list_url_thumb'] ?>')"<?= $_COOKIE['index_list_url_thumb'] == 'on' ? ' checked' : '' ?>>サムネイル</label>
<?php if ($_COOKIE['index_list_url_thumb'] <> 'on') { ?>
	<label><input type="checkbox" onClick="ListCaptureOnOff(this)"<?= $_COOKIE['index_list_url_capture'] == 'none' ? ' checked' : '' ?>>キャプチャ非表示</label>
<?php	} ?>
	</form>
</div>
<div id="body">
<div id="filemanager_body">
<?php
	if ($file_mode == 'Folder') {
		if ($_SESSION['index_list_url_search_key'].'' <> '' and $_COOKIE['index_list_url_subdir'] == 'on') {
			search_file($open_path, $path_SJIS, $_SESSION['index_list_url_search_key']);
		} else {
			view_folder($open_path, $path_SJIS, $_SESSION['index_list_url_search_key']);
		}
	} else {
		echo '<p class="error_msg">'.$error_msg.'</p>';
	}
?>
</div>
</div>
<?php
}
function view_folder($open_path, $path_SJIS, $search_key) {
	$prt_dir = array();
	$prt_file = array();
	if ($dir = opendir($path_SJIS)) {
		$files = scandir($path_SJIS);
		natcasesort($files);
		$order = 0;
		error_reporting(0);	// 文字「≫」(Shift-JIS:0x81E2) : stat()でエラーになる
		foreach ($files as $file) {
			if ($file != "." && $file != "..") {
				$filepath_SJIS = $path_SJIS.'/'.$file;
				if (is_dir($filepath_SJIS)) {
					$prt_dir[] = $file;
				} else {
					if (is_ext_filename_str($file, 'url')) {
						if (($stat = stat($filepath_SJIS)) <> False) {
							$prt_file[] = array($file, $type, $stat['size'], $stat['mtime']);
							$prt_file_name[] = $file;
							$prt_file_size[] = $stat['mtime'];
							
						} else {
							// 文字「≫」(Shift-JIS:0x81E2) : stat()でエラーになる
							$prt_file[] = array($file, $type, 0, 0);
							$prt_file_name[] = $file;
							$prt_file_size[] = 0;
						}
						// array_multisort()で日本語の順番が乱れる対策としてnatcasesort()の順番を使う
						$prt_order[] = ++$order;
					}
				}
			}
		}
		error_reporting(E_ALL ^ E_NOTICE);
		closedir($dir);
	}
	print_dir($open_path, $prt_dir, $search_key);
	print_file($open_path, $prt_file, $search_key, $prt_file_name, $prt_file_size, $prt_order);
}
function print_dir($open_path, $prt_dir, $search_key) {
?>
	<div id="print_dir">
	<ul class="file_list">
<?php
	foreach ($prt_dir as $dir) {
		$file_UTF = myfile_DECODE($dir);
		$path_UTF = $open_path.'/'.myfile_DECODE($dir);
		if ($search_key == '' or ($search_key <> '' and stripos_multi_and(basename($path_UTF), $search_key))) {
?>
		<li class="file_folder"><a href="<?= $_SERVER['SCRIPT_NAME'] ?>?path=<?= urlencode($path_UTF) ?>&key=<?= urlencode($search_key) ?>"><?= $file_UTF ?></a>
		<input type="button" class="copy_button" value="Ｃ" onClick="location.href='folder-copy.php?path=<?= urlencode($path_UTF) ?>'">
		<input type="button" class="copy_button" value="Ｒ" onClick="rename_folder('<?= escape_squote($path_UTF) ?>', '<?= escape_squote($file_UTF) ?>')">
		<input type="button" class="copy_button" value="Ｄ" onClick="delete_folder('<?= escape_squote($path_UTF) ?>')">
		</li>
<?php
		}
	}
?>
	</ul>
	</div>
<?php
}
function print_file($open_path, $prt_file, $search_key, $prt_file_name, $prt_file_size, $prt_order) {
	if (!$prt_file_name) return;
?>
	<div id="print_file">
<?php
	if ($_SESSION['index_list_url_sort'] == 'date') {
		if ($_SESSION['index_list_url_sort_order'] == 'desc') {
			array_multisort($prt_file_size, SORT_DESC, $prt_file);
		} else {
			array_multisort($prt_file_size, SORT_ASC, $prt_file);
		}
	} else {
		if ($_SESSION['index_list_url_sort_order'] == 'desc') {
			// array_multisort()で日本語の順番が乱れる対策としてnatcasesort()の順番を使う
			array_multisort($prt_order, SORT_DESC, $prt_file);
		}
	}
	if ($_COOKIE['index_list_url_thumb'] == 'on') {
		url_thumb($open_path, $prt_file, $search_key);
	} else {
		url_list($open_path, $prt_file, $search_key);
	}
?>
	</div>
<?php
}
function url_thumb($open_path, $prt_file, $search_key) {
?>
	<ul class="index_thumbnail">
<?php
		foreach ($prt_file as $file) {
			$file_UTF = myfile_DECODE($file[0]);
			if ($search_key == '' or ($search_key <> '' and stripos_multi_and($file_UTF, $search_key))) {
				url_thumb_print($open_path, $file_UTF);
			}
		}
?>
	</ul>
<?php
}
function url_thumb_print($open_path, $file_UTF) {
	$url = '';
	$path_UTF = $open_path.'/'.$file_UTF;
	$url = get_url_from_urlfile($path_UTF);
	$file_UTF = basename($file_UTF, '.url');
	$path_UTF = $open_path.'/'.$file_UTF;
?>
	<li>
	<p class="index_thumbnail_title"><a href="<?= $url ?>" target="_blank"><?= my_htmlspecialchars(mb_strimwidth($file_UTF, 0, 21, "..")) ?></a></p>
	<a href="<?= $url ?>" target="_blank" title="<?= $file_UTF ?>"><img src="http://img.simpleapi.net/small/<?= $url ?>"></a>
	</li>
<?php
}
function url_list($open_path, $prt_file, $search_key) {
	$href = $_SERVER['SCRIPT_NAME'] . '?path=' .urlencode($open_path);
	if ($_SESSION['index_list_url_sort'] == 'date') {
		if ($_SESSION['index_list_url_sort_order'] == 'desc') {
			$date_ch_order = '&order=asc';
			$date_om = '<span class="order_mark">▼</span>';
		} else {
			$date_ch_order = '&order=desc';
			$date_om = '<span class="order_mark">▲</span>';
		}
	} else {
		if ($_SESSION['index_list_url_sort_order'] == 'desc') {
			$name_ch_order = '&order=asc';
			$name_om = '<span class="order_mark">▼</span>';
		} else {
			$name_ch_order = '&order=desc';
			$name_om = '<span class="order_mark">▲</span>';
		}
	}
?>
	<table>
	<tr><a name="file" /></a>
<?php	if ($_COOKIE['index_list_url_capture'] <> 'none') { ?>
	<th><br></th>
<?php	} ?>
	<th class="file_list"><a href="<?= $href ?>&sort=name<?= $name_ch_order ?>#file">タイトル</a><?= $name_om ?></th>
	<th class="file_time"><a href="<?= $href ?>&sort=date<?= $date_ch_order ?>#file">更新日時</a><?= $date_om ?></th>
	</tr>
<?php
	foreach ($prt_file as $file) {
		$file_UTF = myfile_DECODE($file[0]);
		if ($search_key == '' or ($search_key <> '' and stripos_multi_and($file_UTF, $search_key))) {
			url_list_print($open_path, $file_UTF, $file[3]);
		}
	}
?>
	</table>
<?php
}
function url_list_print($open_path, $file_UTF, $timestamp) {
	$url = '';
	$path_UTF = $open_path.'/'.$file_UTF;
	$url = get_url_from_urlfile($path_UTF);
	$file_UTF = basename($file_UTF, '.url');
	$path_UTF = $open_path.'/'.$file_UTF;
?>
	<tr>
<?php	if ($_COOKIE['index_list_url_capture'] <> 'none') { ?>
		<td class="index_list_capture">
		<a href="<?= $url ?>" target="_blank"><img src="http://img.simpleapi.net/small/<?= $url ?>"></a>
		</td>
<?php	} ?>
	<td class="file_list" nowrap>
		<span class="file_url">
<?php			if ($url <> '') {	?>
			<a href="<?= $url ?>" target="_blank"><?= $file_UTF ?></a>
<?php			} else {	?>
			<span style="color:red;font-weight:bold;">エラー：</span><?= $file_UTF ?>
<?php			}	?>
		</span>
	<input type="button" class="copy_button" value="Ｒ" onClick="rename_file('<?= escape_squote($path_UTF) ?>', '<?= escape_squote($file_UTF) ?>')">
	<input type="button" class="copy_button" value="Ｄ" onClick="delete_file('<?= escape_squote($path_UTF) ?>')">
		<p class="index_list_url"><?= $url ?></p>
	</td>
	<td class="file_time"><?= date("Y/m/d H:i", $timestamp) ?></td>
	</tr>
<?php
}
function folder_check($open_path, &$path_SJIS, &$error_msg) {
	$path_SJIS = myfile_ENCODE($open_path);
	if (file_exists($path_SJIS)) {
		if (is_dir($path_SJIS)) {
			return 'Folder';
		} else {
			$error_msg =  'ファイル『 '.$open_path.' 』は表示できません。';
			return 'File';
		}
	} else {
		$error_msg =  'フォルダまたはファイル『 '.$open_path.' 』が、みつかりません。';
		return 'Error';
	}
}
function search_file($open_path, $path_SJIS, $search_key) {
?>
	<div id="print_file">
<?php
	if ($_COOKIE['index_list_url_thumb'] <> 'on') {
?>
		<table>
		<tr><a name="file" /></a>
	<?php	if ($_COOKIE['index_list_url_capture'] <> 'none') { ?>
		<th><br></th>
	<?php	} ?>
		<th class="file_list">タイトル</th>
		</tr>
<?php	} else { ?>
		<ul class="index_thumbnail">
<?php
	}
	scan_file($open_path, $search_key);
	if ($_COOKIE['index_list_url_thumb'] <> 'on') {
?>
		</table>
<?php	} else { ?>
		</ul>
<?php
	}
?>
	</div>
<?php
}
function scan_file($open_path, $search_key) {
//echo '==='.$search_dir.'<br>';
/*
	$search_dir = $open_path.'/*';
	foreach (glob(myfile_ENCODE($search_dir), GLOB_ONLYDIR) as $child_dir) {
		scan_file(myfile_DECODE($child_dir), $search_key);
	}
	$search_path = $open_path.'/*'.$search_key.'*.url';
	// *** glob()は、英大文字/英小文字を区別してしまう
	foreach (glob(myfile_ENCODE($search_path), GLOB_BRACE) as $file) {
		$file_UTF = myfile_DECODE($file);
		if ($_COOKIE['index_list_url_thumb'] == 'on') {
			url_thumb_print(dirname($file_UTF), basename($file_UTF));
		} else {
			url_list_print_scan(dirname($file_UTF), basename($file_UTF));
		}
	}
*/
	$path_SJIS = myfile_ENCODE($open_path);
	$files = scandir($path_SJIS);
	natcasesort($files);
	$order = 0;
	error_reporting(0);	// 文字「≫」(Shift-JIS:0x81E2) : stat()でエラーになる
	foreach ($files as $file) {
		if ($file != "." && $file != "..") {
			$file_UTF = myfile_DECODE($file);
			$filepath_SJIS = $path_SJIS.'/'.$file;
			if (is_dir($filepath_SJIS)) {
				if (stripos_multi_and($file_UTF, $search_key)) {
?>
			</ul>
			<p class="folder_direct_dir"><?= up_folder_direct('?path=', $open_path.'/'.$file_UTF) ?></p>
			<ul class="index_thumbnail">
<?php
				}
				scan_file($open_path.'/'.myfile_DECODE($file), $search_key);
			} else {
				if (is_ext_filename_str($file, 'url')) {
					if (stripos_multi_and($file_UTF, $search_key)) {
						if ($_COOKIE['index_list_url_thumb'] == 'on') {
							url_thumb_print($open_path, $file_UTF);
						} else {
							url_list_print_scan($open_path, $file_UTF);
						}
					}
				}
			}
		}
	}
	error_reporting(E_ALL ^ E_NOTICE);
}
function url_list_print_scan($open_path, $file_UTF) {
	$url = '';
	$path_UTF = $open_path.'/'.$file_UTF;
	$url = get_url_from_urlfile($path_UTF);
	$file_UTF = basename($file_UTF, '.url');
	$path_UTF = $open_path.'/'.$file_UTF;
?>
	<tr>
<?php	if ($_COOKIE['index_list_url_capture'] <> 'none') { ?>
		<td class="index_list_capture">
		<a href="<?= $url ?>" target="_blank"><img src="http://img.simpleapi.net/small/<?= $url ?>"></a>
		</td>
<?php	} ?>
	<td class="file_list" nowrap>
		<span class="file_url">
		<p class="folder_direct"><?= up_folder_direct('?path=', $open_path) ?></p>
<?php			if ($url <> '') {	?>
			<a href="<?= $url ?>" target="_blank"><?= $file_UTF ?></a>
<?php			} else {	?>
			<span style="color:red;font-weight:bold;">エラー：</span><?= $file_UTF ?>
<?php			}	?>
		</span>
		<p class="index_list_url"><?= $url ?></p>
	</td>
	</tr>
<?php
}
function get_url_from_urlfile($path_UTF) {
	$path_SJIS = myfile_ENCODE($path_UTF);
	$fp = @fopen($path_SJIS, 'r');
	while ($line=@fgets($fp, 4096)) {
		if (left($line,4) == 'URL=') {
			@fclose($fp);
			return mb_substr($line,4);
		}
	}
}
?>
