/* common_funcs.cpp
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of Mysaifu JVM

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.
*/

#include "StdAfx.h"
#include "common_funcs.h"

/**
 * JVM̃o[W
 */
static LARGE_INTEGER g_jvm_version;

/**
 * vIȃG[Ƃ_CAO{bNX\A
 * vOI
 */
void fatal_error(const _TCHAR* msg) {
	if (msg == FATAL_ERROR_NO_MEMORY) {
		SHShowOutOfMemory(NULL, 0);
	} else {
		MessageBox(NULL,
				   msg,
				   _T("Mysaifu JVM fatal error"),
				   MB_OK);
	}
	exit(1);
}

/**
 * JVM̃o[WԂ
 */
LARGE_INTEGER get_jvm_version() {
	if (! g_jvm_version.QuadPart) {
		// JVM̐mȃo[W擾
		HMODULE hModule = GetModuleHandle(NULL);
		_TCHAR filename[MAX_PATH + 1];
		GetModuleFileName(hModule, filename, MAX_PATH);
		DWORD cbBlock = GetFileVersionInfoSize(filename, 0);
		BYTE* pbBlock = (BYTE*) malloc(sizeof(BYTE) * cbBlock);
		if (pbBlock) {
			GetFileVersionInfo(filename, 0, cbBlock, pbBlock);

			LPVOID pvBuf = NULL;
			UINT uLen = 0;
			VerQueryValue((const LPVOID)pbBlock, _T("\\"), &pvBuf, &uLen);

			VS_FIXEDFILEINFO* vfi = (VS_FIXEDFILEINFO *)pvBuf;

			if (vfi->dwSignature == 0xfeef04bd) {
				g_jvm_version.HighPart = vfi->dwProductVersionMS;
				g_jvm_version.LowPart = vfi->dwProductVersionLS;
			}
			free(pbBlock);
		}
	}
	return g_jvm_version;
}