#include <windows.h>
#include <jni.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCETextFieldPeer.h>

/*
 * Class:     gnu_java_awt_peer_wce_WCETextFieldPeer
 * Method:    createNative
 * Signature: (IIIII)I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_WCETextFieldPeer_createNative(JNIEnv *env, jobject peer_obj, jint parentWindowHandle, jint x, jint y, jint width, jint height) {
	peer_obj = (*env)->NewGlobalRef(env, peer_obj);
	return (jint) create_native_text_field(peer_obj, (HWND) parentWindowHandle, x, y, width, height);	
}

/*
 * Class:     gnu_java_awt_peer_wce_WCETextFieldPeer
 * Method:    getNativePreferredSize
 * Signature: (II)Ljava/awt/Dimension;
 */
JNIEXPORT jobject JNICALL Java_gnu_java_awt_peer_wce_WCETextFieldPeer_getNativePreferredSize(JNIEnv *env, jobject peer_obj, jint windowHandle, jint len) {
	jclass clazz;
	jobject dim = NULL;
	int cx, cy, width, height;

	SIZE size;
	get_text_extent_point((HWND) windowHandle, _T("A"), &size);

	// VXe擾
	cx = GetSystemMetrics(SM_CXBORDER);
	cy = GetSystemMetrics(SM_CYBORDER);
	
	width = (int) (size.cx * len * 1.1 + cx * 2);
	height = (int) (size.cy * 1.1 + cy * 2);

	clazz = (*env)->FindClass(env, "java/awt/Dimension");
	if (clazz) {
		jmethodID constructor_id
				= (*env)->GetMethodID(env, clazz, "<init>", "(II)V");
		if (constructor_id) {
			dim = (*env)->NewObject(env,
									clazz,
									constructor_id,
									width,
									height);
		}
	}
	return dim;
}

/*
 * Class:     gnu_java_awt_peer_wce_WCETextFieldPeer
 * Method:    setNativeEchoChar
 * Signature: (IC)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCETextFieldPeer_setNativeEchoChar(JNIEnv *env, jobject peer_obj, jint windowHandle, jchar echoChar) {
	HWND hwnd = (HWND) windowHandle;
	assert(windowHandle);
/*
	DWORD style;
	style = GetWindowLong(hwnd, GWL_STYLE);
	if (echoChar) {
		style |= ES_PASSWORD;
	} else {
		style &= ~ES_PASSWORD;
	}
	SetWindowLong(hwnd, GWL_STYLE, (LONG) style);
*/
	SendMessage(hwnd, EM_SETPASSWORDCHAR, (WPARAM) echoChar, 0);
}