/* gnu_java_awt_peer_wce_WCEURLImage.c
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <windows.h>
#include <aygshell.h>
#include <jni.h>
#include <assert.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCEURLImage.h>

/*
 * Class:     gnu_java_awt_peer_wce_WCEURLImage
 * Method:    createNativeBitmapHandle
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_WCEURLImage_createNativeBitmapHandle(JNIEnv *env,
																					   jobject obj,
																					   jint windowHandle,
																					   jstring filename) {
	HBITMAP hbitmap;
	_TCHAR* buff = get_string_chars(env, filename);
	// obt@ '/' ׂ '\' ɒu
	int len = _tcslen(buff);
	int i;
	for (i = 0; i < len; ++i) {
		if (buff[i] == '/') {
			buff[i] = '\\';
		}
	}

	hbitmap = SHLoadImageFile(buff);	// ToDo:sȃtH[}bg̃t@Cǂ܂ƃnOĂ܂sւ̑Ή
	free(buff);
	if (hbitmap) {
		BITMAP bitmap;
		// rbg}bv̕ƍ擾AsetDimension()\bhĂяo
		if (GetObject(hbitmap, sizeof(BITMAP), &bitmap)) {
			jclass clazz = (*env)->GetObjectClass(env, obj);
			if (! clazz) {
				throw_AWTError(env, "GetObjectClass() failed.");
			} else {
				jmethodID mid = (*env)->GetMethodID(env,
													clazz,
													"setDimension",
													"(II)V");
				if (mid) {
					(*env)->CallVoidMethod(env,
										   obj,
										   mid,
										   bitmap.bmWidth,
										   bitmap.bmHeight);
				}
			}
		}
	}
	return (jint) hbitmap;
}
