/* gnu_java_awt_peer_wce_font_WCEFontMetrics.c
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <windows.h>
#include <jni.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_font_WCEFontMetrics.h>

/*
 * Class:     gnu_java_awt_peer_wce_font_WCEFontMetrics
 * Method:    loadNativeFontMetrics
 * Signature: (II[I)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_font_WCEFontMetrics_loadNativeFontMetrics(JNIEnv *env, jobject obj, jint fontHandle, jintArray metrics) {
	HFONT hFont = (HFONT) fontHandle;
	HFONT hOldFont;
	TEXTMETRIC tm;
	HDC hdc = GetDC(NULL);
	jint* result;

	hOldFont = SelectObject(hdc, hFont);

	// TEXTMETRIC\̂擾
	GetTextMetrics(hdc, &tm);

	result = (*env)->GetIntArrayElements(env, metrics, NULL);
	if (result) {
		result[0] = tm.tmAscent;
		result[1] = tm.tmDescent;
		result[2] = tm.tmMaxCharWidth;
		(*env)->ReleaseIntArrayElements(env, metrics, result, 0);
	}

	SelectObject(hdc, hOldFont);
	ReleaseDC(NULL, hdc);
}

/*
 * Class:     gnu_java_awt_peer_wce_font_WCEFontMetrics
 * Method:    getNativeStringWidth
 * Signature: (IILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_font_WCEFontMetrics_getNativeStringWidth(JNIEnv *env, jobject obj, jint fontHandle, jstring str) {
	SIZE size;
	HFONT hOldFont;
	HFONT hFont = (HFONT) fontHandle;
	HDC hdc = GetDC(NULL);
	const _TCHAR* tmp;
	jint length;
	_TCHAR* buff;

	if (! str) {
		jclass clazz = (*env)->FindClass(env, "java/lang/NullPointerException");
		if (clazz) {
			(*env)->ThrowNew(env, clazz, NULL);
		}
		return 0;
	}
	tmp = (*env)->GetStringChars(env, str, NULL);
	length = (*env)->GetStringLength(env, str);
	buff = (_TCHAR*) malloc(sizeof(_TCHAR) * (length + 1));
	if (! buff) {
		throw_AWTError(env, "Failed to allocate a buffer.");
		return 0;
	}
	_tcsncpy(buff, tmp, length);
	buff[length] = _T('\0');
	(*env)->ReleaseStringChars(env, str, tmp);

	// eLXg̃TCY擾
	hOldFont = SelectObject(hdc, hFont);
	GetTextExtentPoint(hdc, buff, length, &size);
	free(buff);
	SelectObject(hdc, hOldFont);

	ReleaseDC(NULL, hdc);

	return size.cx;
}