/* WCEChoicePeer.java -- Button peer
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce;

import java.awt.Choice;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.peer.ChoicePeer;

public class WCEChoicePeer extends WCEComponentPeer implements ChoicePeer {
	WCEChoicePeer(Choice choice) {
		super(choice);
		// ACeǉĂ
		int count = choice.getItemCount();
		int windowHandle = getWindowHandle();
		for (int i = 0; i < count; ++i) {
			String item = choice.getItem(i);
			add(item, i);
		}
		select(choice.getSelectedIndex());
	}
	
	protected native int createNative(int parentWindowHandle, int x, int y, int width, int height);
	
	public void add(String item, int index) {
		if (item == null) {
			throw new NullPointerException();
		}
		addNative(getWindowHandle(), item, index);
	}
	
	private native void addNative(int windowHandle, String item, int index);
	
	public void addItem(String item, int index) {
		add(item, index);
	}

	public void remove(int index) {
		removeNative(getWindowHandle(), index);
	}
	
	private native void removeNative(int windowHandle, int index);
	
	public void removeAll() {
		removeNativeAll(getWindowHandle());
	}
	
	private native void removeNativeAll(int windowHandle);
	
	public void select (int index) {
		selectNative(getWindowHandle(), index);
	}
	
	private native void selectNative(int windowHandle, int index);

	protected native Dimension getNativePreferredSize(int windowHandle);

	public void setBounds(int x, int y, int width, int height) {
		// Windows  COMBOBOX ̍́AXg܂ނ
		// Xg̍𑫂Ă
		// ݂̎ł́AŒ100𑫂Ă
		super.setBounds(x, y, width, height + 100);
	}

	/**
	 * ItemEventpost
	 */
	protected void postItemEvent(int id,
								 int index,
								 int stateChange) {
		Choice choice = (Choice) getComponent();
		if (stateChange == ItemEvent.SELECTED) {
			choice.select(index);
		}
		queue.postEvent(
			new ItemEvent(choice,
				   		  id,
				   		  choice.getItem(index),
				   		  stateChange)
			);
	}

}

