package gnu.javax.sound.sampled.wce;


import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;

public class WCEMixerProvider extends MixerProvider {
	static {
		System.loadLibrary("wcesound");
	}
	
	/**
	 * T|[gĂ~LT[
	 */
	static Mixer.Info mixerInfo
		= new WCEMixerInfo("Windows CE mixer",
						   "Mysaifu.com",
						   "",
						   "0.0.1");
	
	public boolean isMixerSupported(Mixer.Info info) {
		return mixerInfo.equals(info);
	}
	
	public Mixer.Info[] getMixerInfo() {
		// ToDo: Ǝ
		return new Mixer.Info[] { mixerInfo };
	}

	public Mixer getMixer(Mixer.Info info) {
		if (info == null || mixerInfo.equals(info)) {
			return new WCEMixer(mixerInfo);
		}
		throw new IllegalArgumentException("Unsupported Mixer.Info:" + info);
	}
	
	/**
	 * Mixer.Info
	 */
	static class WCEMixerInfo extends Mixer.Info {
		WCEMixerInfo(String name,
					 String vendor,
					 String description,
					 String version) {
			super(name, vendor, description, version);
		}
	}
}
