/* string.c
   Copyright (C) 2006 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <stddef.h>
#include <string.h>
#include <errno.h>

char * _sys_errlist[] =
{
/* NOERROR 0 */           "No error",
/* EPERM 1 */             "Operation not permitted",
/* ENOENT 2 */            "No such file or directory",
/* ESRCH 3 */             "No such process",
/* EINTR 4 */             "Interrupted system call",
/* EIO 5 */               "Input/Output error",
/* ENXIO 6 */             "No such device or address",
/* E2BIG 7 */             "Argument list too long",
/* ENOEXEC 8 */           "Exec format error",
/* EBADF 9 */             "Bad file descriptor",
/* ECHILD 10 */           "No child processes",
/* EAGAIN 11 */           "Resource temporarily unavailable",
/* ENOMEM 12 */           "Cannot allocate memory",
/* EACCES 13 */           "Permission denied",
/* EFAULT 14 */           "Bad address",
/* ENOTBLK 15 */          "Block device required",
/* EBUSY 16 */            "Device or resource busy",
/* EEXIST 17 */           "File exists",
/* EXDEV 18 */            "Invalid cross-device link",
/* ENODEV 19 */           "No such device",
/* ENOTDIR 20 */          "Not a directory",
/* EISDIR 21 */           "Is a directory",
/* EINVAL 22 */           "Invalid argument",
/* ENFILE 23 */           "Too many open files in system",
/* EMFILE 24 */           "Too many open files",
/* ENOTTY 25 */           "Inappropriate ioctl for device",
/* ETXTBSY 26 */          "Text file busy",
/* EFBIG 27 */            "File too large",
/* ENOSPC 28 */           "No space left on device",
/* ESPIPE 29 */           "Illegal seek",
/* EROFS 30 */            "Read-only file system",
/* EMLINK 31 */           "Too many links",
/* EPIPE 32 */            "Broken pipe",
/* EDOM 33 */             "Numerical argument out of domain",
/* ERANGE 34 */           "Numerical result out of range",
/* ENOMSG 35 */           "No message of desired type",
/* EIDRM 36 */            "Identifier removed",
/* ECHRNG 37 */           "Channel number out of range",
/* EL2NSYNC 38 */         "Level 2 not synchronized",
/* EL3HLT 39 */           "Level 3 halted",
/* EL3RST 40 */           "Level 3 reset",
/* ELNRNG 41 */           "Link number out of range",
/* EUNATCH 42 */          "Protocol driver not attached",
/* ENOCSI 43 */           "No CSI structure available",
/* EL2HLT 44 */           "Level 2 halted",
/* EDEADLK 45 */          "Resource deadlock avoided",
/* ENOLCK 46 */           "No locks available",
                            "error 47",
                            "error 48",
                            "error 49",
/* EBADE 50 */            "Invalid exchange",
/* EBADR 51 */            "Invalid request descriptor",
/* EXFULL 52 */           "Exchange full",
/* ENOANO 53 */           "No anode",
/* EBADRQC 54 */          "Invalid request code",
/* EBADSLT 55 */          "Invalid slot",
/* EDEADLOCK 56 */        "File locking deadlock error",
/* EBFONT 57 */           "Bad font file format",
                            "error 58",
                            "error 59",
/* ENOSTR 60 */           "Device not a stream",
/* ENODATA 61 */          "No data available",
/* ETIME 62 */            "Timer expired",
/* ENOSR 63 */            "Out of streams resources",
/* ENONET 64 */           "Machine is not on the network",
/* ENOPKG 65 */           "Package not installed",
/* EREMOTE 66 */          "Object is remote",
/* ENOLINK 67 */          "Link has been severed",
/* EADV 68 */             "Advertise error",
/* ESRMNT 69 */           "Srmount error",
/* ECOMM 70 */            "Communication error on send",
/* EPROTO 71 */           "Protocol error",
                            "error 72",
                            "error 73",
/* EMULTIHOP 74 */        "Multihop attempted",
/* ELBIN 75 */            "Inode is remote (not really error)",
/* EDOTDOT 76 */          "RFS specific error",
/* EBADMSG 77 */          "Bad message",
                            "error 78",
/* EFTYPE 79 */           "Inappropriate file type or format",
/* ENOTUNIQ 80 */         "Name not unique on network",
/* EBADFD 81 */           "File descriptor in bad state",
/* EREMCHG 82 */          "Remote address changed",
/* ELIBACC 83 */          "Can not access a needed shared library",
/* ELIBBAD 84 */          "Accessing a corrupted shared library",
/* ELIBSCN 85 */          ".lib section in a.out corrupted",
/* ELIBMAX 86 */          "Attempting to link in too many shared libraries",
/* ELIBEXEC 87 */         "Cannot exec a shared library directly",
/* ENOSYS 88 */           "Function not implemented",
/* ENMFILE 89 */          "No more files",
/* ENOTEMPTY 90 */          "Directory not empty",
/* ENAMETOOLONG 91 */     "File name too long",
/* ELOOP 92 */            "Too many levels of symbolic links",
                            "error 93",
                            "error 94",
/* EOPNOTSUPP 95 */       "Operation not supported",
/* EPFNOSUPPORT 96 */     "Protocol family not supported",
                            "error 97",
                            "error 98",
                            "error 99",
                            "error 100",
                            "error 101",
                            "error 102",
                            "error 103",
/* ECONNRESET 104 */      "Connection reset by peer",
/* ENOBUFS 105 */         "No buffer space available",
/* EAFNOSUPPORT 106 */    "Address family not supported by protocol",
/* EPROTOTYPE 107 */      "Protocol wrong type for socket",
/* ENOTSOCK 108 */        "Socket operation on non-socket",
/* ENOPROTOOPT 109 */     "Protocol not available",
/* ESHUTDOWN 110 */       "Cannot send after transport endpoint shutdown",
/* ECONNREFUSED 111 */    "Connection refused",
/* EADDRINUSE 112 */      "Address already in use",
/* ECONNABORTED 113 */    "Software caused connection abort",
/* ENETUNREACH 114 */     "Network is unreachable",
/* ENETDOWN 115 */        "Network is down",
/* ETIMEDOUT 116 */       "Connection timed out",
/* EHOSTDOWN 117 */       "Host is down",
/* EHOSTUNREACH 118 */    "No route to host",
/* EINPROGRESS 119 */     "Operation now in progress",
/* EALREADY 120 */        "Operation already in progress",
/* EDESTADDRREQ 121 */    "Destination address required",
/* EMSGSIZE 122 */        "Message too long",
/* EPROTONOSUPPORT 123 */ "Protocol not supported",
/* ESOCKTNOSUPPORT 124 */ "Socket type not supported",
/* EADDRNOTAVAIL 125 */   "Cannot assign requested address",
/* ENETRESET 126 */       "Network dropped connection on reset",
/* EISCONN 127 */         "Transport endpoint is already connected",
/* ENOTCONN 128 */        "Transport endpoint is not connected",
/* ETOOMANYREFS 129 */    "Too many references: cannot splice",
/* EPROCLIM 130 */        "Too many processes",
/* EUSERS 131 */          "Too many users",
/* EDQUOT 132 */          "Disk quota exceeded",
/* ESTALE 133 */          "Stale NFS file handle",
/* ENOTSUP 134 */         "Not supported",
/* ENOMEDIUM 135 */       "No medium found",
/* ENOSHARE 136 */        "No such host or network path",
/* ECASECLASH 137 */      "Filename exists with different case",
/* EILSEQ 138 */          "Invalid or incomplete multibyte or wide character",
/* EOVERFLOW 139 */       "Value too large for defined data type"
};

char *strerror(int errnum) {
	if (errnum >= (sizeof(_sys_errlist) / sizeof(_sys_errlist[0]))) {
		errno = EINVAL;
		return NULL;
	}
	return _sys_errlist[errnum];
}
