/* java_utf8.h
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of Mysaifu JVM

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.
*/

#ifndef JAVA_UTF8_H_INCLUDED
#define	JAVA_UTF8_H_INCLUDED

/**
 * Java UTF-8
 */
typedef const char	java_utf8;
// struct java_utf8 {};

#include "ClassFile.h"

/**
 * frame\
 */
struct frame;

/**
 * UTF-8֘A
 */
void init_utf8_settings();

/**
 * w肳ꂽUTF-8uC^[v
 */
java_utf8* intern_utf8(const char* utf8);
java_utf8* intern_utf8(const char* utf8, int length);

/**
 * w肳ꂽUTF-8ɑΉString̎QƂX^bNpush
 * pushString̎QƂ String.intern() ꂽʂƂȂB
 *
 * @param	utf8	ΏۂƂȂUTF-8
 * @param	frame	String̎QƂpushX^bN
 * @return	X^bNpushꂽString̎QƁB
 */
jstring intern_string(const char* utf8, frame* frame);

#define	utf8cmp	strcmp

/**
 * TCHARUTF-8Ƃ̔rsBQ̕\ꍇtrueԂB
 */
bool equals(const TCHAR* str, const char* utf8);

/**
 * QUTF-8̓erAꍇtrueԂ
 *
 */
inline bool equals(const char* str1, const char* str2) {
	return strcmp(str1, str2) == 0;
}

/**
 * UTF-8ATCHARɕϊ
 *
 * @param	utf8	ϊB'\0' ŏI[Ă邱ƁB
 * @param	buff	TCHAR̃obt@
 * @param	bufflen TCHARobt@̃TCY
 * @return	ϊTCHAR̒
 */
int convert_to_TCHAR(const char* utf8, TCHAR* buff, unsigned int bufflen);

/**
 * TCHAR̓eAUTF-8ɕϊ
 * ϊUTF-8́AK'\0'ŏI[
 *
 * @param	src			TCHAR̃obt@
 * @param	srclen		ϊΏۂƂȂ镶B-1̏ꍇɂ_T('\0')܂łϊΏۂƂ
 * @param	utf8buff	ϊ̂̃f[^obt@
 * @param	utf8bufflen	ϊ̃obt@TCY
 * @return  ϊ̒̕
 */
int convert_to_utf8(const TCHAR* src, int srclen, char* utf8, int utf8len);

/**
 * w肳ꂽTCHARUTF-8ɕϊꍇ̃oCgԂ
 *
 * @param	src		ϊΏۂƂȂ镶
 * @param	srclen	ϊ镶
 */
int get_utf8_length_of(const TCHAR* src, int srclen);

/**
 * w肳ꂽoCg݂ʒuԂB
 */
int last_index_of(const java_utf8* utf8, u1 data);

// O[oϐ

/**
 * java.lang.ClassNX
 */
extern java_utf8* CLASS_CLASS_NAME;

/**
 * java.lang.StringNX
 */
extern java_utf8* STRING_CLASS_NAME;

/**
 * "<clinit>"\bh
 */
extern java_utf8* CLINIT_METHOD_NAME;

/**
 * 	"<init>"\bh
 */
extern java_utf8* INIT_METHOD_NAME;

/**
 * "finalize()"\bh
 */
extern java_utf8* FINALIZE_METHOD_NAME;

/**
 * "finalize()"\bh̃fBXNv^ ("()V")
 */
extern java_utf8* VOID_NOARG_METHOD_DESCRIPTOR;

/**
 * clone() \bh
 */
extern java_utf8* CLONE_METHOD_NAME;

/**
 * java/lang/Object
 */
extern java_utf8* JAVA_LANG_OBJECT_CLASS_NAME;

/**
 * java/lang/Cloneable
 */
extern java_utf8* JAVA_LANG_CLONEABLE_CLASS_NAME;

/**
 * java/io/Serializable
 */
extern java_utf8* JAVA_IO_SERIALIZABLE_CLASS_NAME;

/**
 * v~eBuzNX
 */
extern const  java_utf8* BOOLEAN_ARRAY_CLASS_NAME;
extern const  java_utf8* BYTE_ARRAY_CLASS_NAME;
extern const  java_utf8* SHORT_ARRAY_CLASS_NAME;
extern const  java_utf8* CHAR_ARRAY_CLASS_NAME;
extern const  java_utf8* INT_ARRAY_CLASS_NAME;
extern const  java_utf8* LONG_ARRAY_CLASS_NAME;
extern const  java_utf8* FLOAT_ARRAY_CLASS_NAME;
extern const  java_utf8* DOUBLE_ARRAY_CLASS_NAME;
extern const  java_utf8* PRIMITIVE_ARRAY_CLASS_NAMES[];

#endif
