/* gnu_java_awt_peer_wce_WCEButtonPeer.c
   Copyright (C) 2005, 2006 Free Software Foundation, Inc.

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <windows.h>
#include <jni.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCEButtonPeer.h>

/*
 * Class:     gnu_java_awt_peer_wce_WCEButtonPeer
 * Method:    createNative
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_WCEButtonPeer_createNative(JNIEnv *env, jobject peer_obj, jint hwndParent, int x, int y, int width, int height) {
	peer_obj = (*env)->NewGlobalRef(env, peer_obj);
	if (! peer_obj) {
		throw_AWTError(env, "NewGlobalRef failed.");
		return 0;
	}
	return (jint) create_native_button(peer_obj, (HWND) hwndParent, x, y, width, height);
}


/*
 * Class:     gnu_java_awt_peer_wce_WCEButtonPeer
 * Method:    getNativePreferredSize
 * Signature: (I)Ljava/lang/Dimension;
 */
JNIEXPORT jobject JNICALL Java_gnu_java_awt_peer_wce_WCEButtonPeer_getNativePreferredSize(JNIEnv *env, jobject peer_obj, int windowHandle) {
	jclass clazz;
	jmethodID constructor_id;
	jobject dim;
	_TCHAR* buff;
	SIZE size;
	HWND hwnd = (HWND) windowHandle;
	int length, cx, cy;

	// x擾
	length = (int) SendMessage(hwnd, WM_GETTEXTLENGTH, 0, 0);
	buff = (_TCHAR*) malloc(sizeof(_TCHAR) * (length + 1));
	if (! buff) {
		throw_AWTError(env, "Failed to allocate buffer.");
		return NULL;
	}
	SendMessage(hwnd, WM_GETTEXT, (WPARAM) length + 1, (LPARAM) buff);

	// ̃TCY擾
	get_text_extent_point(hwnd, buff, &size);
	free(buff);

	// VXe擾
	cx = GetSystemMetrics(SM_CXBORDER);
	cy = GetSystemMetrics(SM_CYBORDER);

	clazz = (*env)->FindClass(env, "java/awt/Dimension");
	if (! clazz) {
		throw_AWTError(env, "Failed to create Dimension");
		return NULL;
	}

	constructor_id = (*env)->GetMethodID(env, clazz, "<init>", "(II)V");
	if (! constructor_id) {
		throw_AWTError(env, "GetMethodID() failed.");
		return NULL;
	}
	dim = (*env)->NewObject(env,
							clazz,
							constructor_id,
							(int) (size.cx * 1.2 + cx * 2),
							(int) (size.cy * 1.1 + cy * 2));
	return dim;
}


