/* gnu_java_awt_peer_wce_WCEContainerPeer.c
   Copyright (C) 2005-2006 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <windows.h>
#include <tchar.h>
#include <jni.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCEContainerPeer.h>

static jclass g_Insets_class;
static jmethodID g_Insets_constructor_id;

/*
 * Class:     gnu_java_awt_peer_wce_WCEContainerPeer
 * Method:    getNativeInsets
 * Signature: (I)Ljava/awt/Insets;
 */
JNIEXPORT jobject JNICALL Java_gnu_java_awt_peer_wce_WCEContainerPeer_getNativeInsets(JNIEnv *env, jobject peer_obj, int windowHandle) {
	jobject result = NULL;
	DWORD dwStyle = 0;
	jint top = 0, left = 0, bottom = 0, right = 0;

	dwStyle = (DWORD) GetWindowLong((HWND) windowHandle, GWL_STYLE);
	
	// LvVꍇ
	if ((dwStyle & WS_CAPTION) == WS_CAPTION) {
		top += GetSystemMetrics(SM_CYCAPTION);
	}

	// {[_[ꍇ
	if ((dwStyle & WS_BORDER) == WS_BORDER) {
		int cxborder = GetSystemMetrics(SM_CYBORDER);
		int cyborder = GetSystemMetrics(SM_CYBORDER);
		// ㉺EɉZ
		top += cyborder;
		bottom += cyborder;
		left += cxborder;
		right += cxborder;
	}

	// TCYύX\gꍇ
	if ((dwStyle & WS_THICKFRAME) == WS_THICKFRAME) {
		// Windows CEincludet@Cɂ SM_CXSIZEFRAME, SM_CYSIZEFRAME
		// `ĂȂ SM_CXEDGE, SM_CYEDGEőpł?
		// int cxsizeframe = GetSystemMetrics(SM_CXSIZEFRAME);
		// int cysizeframe = GetSystemMetrics(SM_CYSIZEFRAME);
		int cxsizeframe = GetSystemMetrics(SM_CXEDGE);
		int cysizeframe = GetSystemMetrics(SM_CYEDGE);
		// ㉺EɉZ
		top += cysizeframe;
		bottom += cysizeframe;
		left += cxsizeframe;
		right += cxsizeframe;
	}
	
	// ScrollPane̓XN[o[AScrollPane.java̎
	// getInsets()̖߂lɃXN[o[̃TCY͊܂܂ȂƂ
	// OɂĂ邽߁AXN[o[̃TCY͖
/*
	if ((dwStyle & WS_VSCROLL) == WS_VSCROLL) {
		int cx = GetSystemMetrics(SM_CXVSCROLL);
		right += cx;
	}
	// XN[o[ꍇ
	if ((dwStyle & WS_HSCROLL) == WS_HSCROLL) {
		int cy = GetSystemMetrics(SM_CYVSCROLL);
		bottom += cy;
	}
*/

	if (! g_Insets_class) {
		g_Insets_class = (*env)->FindClass(env, "java/awt/Insets");
		if (g_Insets_class) {
			g_Insets_constructor_id = (*env)->GetMethodID(env,
														  g_Insets_class,
														  "<init>",
														  "(IIII)V");
			g_Insets_class = (*env)->NewGlobalRef(env, g_Insets_class);
		}
	}

	if (g_Insets_class && g_Insets_constructor_id) {
		result = (*env)->NewObject(env,
								   g_Insets_class,
								   g_Insets_constructor_id,
								   top,
								   left,
								   bottom,
								   right);
	}
	return result;
	
	// EChETCYƂɂ͐mInsets擾łȂ
	// ȉ̎̓{c
//	RECT clientRect, windowRect;
//	POINT clientOrigin = {0}, clientBottom;
//	jobject result = NULL;
//
//	// NCAg̈ƃEChË̃XN[W擾
//	GetClientRect((HWND) windowHandle, &clientRect);
//	GetWindowRect((HWND) windowHandle, &windowRect);
//	ClientToScreen((HWND) windowHandle, &clientOrigin);
//	clientBottom.x = clientRect.right;
//	clientBottom.y = clientRect.bottom;
//	ClientToScreen((HWND) windowHandle, &clientBottom);
//
//	if (! g_Insets_class) {
//		g_Insets_class = (*env)->FindClass(env, "java/awt/Insets");
//		if (g_Insets_class) {
//			g_Insets_constructor_id = (*env)->GetMethodID(env,
//														  g_Insets_class,
//														  "<init>",
//														  "(IIII)V");
//		}
//	}
//
//	if (g_Insets_constructor_id) {
//		jint top = clientOrigin.y - windowRect.top;
//		jint left = clientOrigin.x - windowRect.left;
//		jint bottom = windowRect.bottom - clientBottom.y;
//		jint right = windowRect.right - clientBottom.x;
//
//		result = (*env)->NewObject(env,
//								   g_Insets_class,
//								   g_Insets_constructor_id,
//								   top,
//								   left,
//								   bottom,
//								   right);
//	}
//	return result;
}

