#include <windows.h>
#include <jni.h>
#include <assert.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCEScrollbarPeer.h>

/*
 * Class:     gnu_java_awt_peer_wce_WCEScrollbarPeer
 * Method:    createNativeScrollbar
 * Signature: (IIIIII)I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_WCEScrollbarPeer_createNativeScrollbar(JNIEnv *env, jobject peer_obj, jint parentWindowHandle, jint x, jint y, jint width, jint height, jint orientation) {
	peer_obj = (*env)->NewGlobalRef(env, peer_obj);
	return (jint) create_native_scrollbar(peer_obj, (HWND) parentWindowHandle, x, y, width, height, orientation);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEScrollbarPeer
 * Method:    setNativeLineIncrement
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEScrollbarPeer_setNativeLineIncrement(JNIEnv *env, jobject peer_obj, jint windowHandle, jint inc) {
	set_scrollbar_line_increment((HWND) windowHandle, inc);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEScrollbarPeer
 * Method:    setNativePageIncrement
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEScrollbarPeer_setNativePageIncrement(JNIEnv *env, jobject peer_obj, jint windowHandle, jint inc) {
	set_scrollbar_page_increment((HWND) windowHandle, inc);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEScrollbarPeer
 * Method:    setNativeValues
 * Signature: (IIIII)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEScrollbarPeer_setNativeValues(JNIEnv *env, jobject peer_obj, jint windowHandle, jint value, jint visible, int min, int max) {
	SCROLLINFO si = {0};
	si.cbSize = sizeof(SCROLLINFO);
	si.fMask = SIF_PAGE | SIF_POS | SIF_RANGE | SIF_DISABLENOSCROLL;
	si.nPos = value;
	si.nPage = visible;
	si.nMin = min;
	si.nMax = max;
	SetScrollInfo((HWND) windowHandle, SB_CTL, &si, TRUE);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEScrollbarPeer
 * Method:    getNativePreferredSize
 * Signature: (I)Ljava/awt/Dimension;
 */
JNIEXPORT jobject JNICALL Java_gnu_java_awt_peer_wce_WCEScrollbarPeer_getNativePreferredSize(JNIEnv *env, jobject peer_obj, jint windowHandle) {
	int width, height;
	DWORD style;
	jclass dimension;
	jobject result = NULL;

	// XN[o[̃^Cv𓾂
	assert(windowHandle);
	style = (DWORD) GetWindowLong((HWND) windowHandle, GWL_STYLE);
	if (style & SBS_VERT) {
		// VXe擾
		int cx_vscroll = GetSystemMetrics(SM_CXVSCROLL);	// XN[o[̕
		int cy_vthumb = GetSystemMetrics(SM_CYVSCROLL);		// XN[o[{^̍
		width = cx_vscroll;
		height = cy_vthumb * 3;
	} else {
		int cx_hthumb = GetSystemMetrics(SM_CXHSCROLL);		// XN[o[{^̕
		int cy_hscroll = GetSystemMetrics(SM_CYHSCROLL);	// XN[o[̍
		width = cx_hthumb * 3;
		height = cy_hscroll;
	}

	dimension = (*env)->FindClass(env, "java/awt/Dimension");
	if (dimension) {
		jmethodID constructor_id
				= (*env)->GetMethodID(env,
									   dimension,
									   "<init>",
									   "(II)V");
		if (constructor_id) {
			result =  (*env)->NewObject(env,
								 dimension,
								 constructor_id,
								 width,
								 height);
		}
	}
	return result;
}
