/* WCEListPeer.java
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package gnu.java.awt.peer.wce;

import java.awt.List;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.peer.ListPeer;

public class WCEListPeer extends WCEComponentPeer implements ListPeer {
	WCEListPeer(List list) {
		super(list);
		// ACeǉĂ
		int count = list.getItemCount();
		int windowHandle = getWindowHandle();
		for (int i = 0; i < count; ++i) {
			String item = list.getItem(i);
			add(item, i);
		}
		
		// IԂ𔽉f
		int[] selectedIndexes = list.getSelectedIndexes();
		if (selectedIndexes != null) {
			// Classpath 0.13ł́AIĂȂnullԂĂ
			for (int i = 0; i < selectedIndexes.length; ++i) {
				select(selectedIndexes[i]);
			}
		}
		
		// ڂ\悤ɂ
		makeVisible(list.getVisibleIndex());
	}
	
	protected int createNative(int parentWindowHandle, int x, int y, int width, int height) {
		// I[hw肵č쐬
		return createNativeList(parentWindowHandle, x, y, width, height, ((List) getComponent()).isMultipleMode());
	}
	
	private native int createNativeList(int parentWindowHandle, int x, int y, int width, int height, boolean multi);

	public void add(String item, int index) {
		if (item == null) {
			// null̏ꍇ͋󕶎Ƃ݂Ȃ
			item = "";
		}
		addNative(getWindowHandle(), item, index);
	}
	
	private native void addNative(int windowHandle, String item, int index);
	
	public void addItem(String item, int index) {
		add(item, index);
	}

	public void clear() {
		removeAll();
	}

	public void delItems(int start, int end) {
		delItemsNative(getWindowHandle(), start, end);
	}
	
	private native void delItemsNative(int windowHandle, int start, int end);
	
	public void deselect(int index) {
		deselectNative(getWindowHandle(), index);
	}
	
	private native void deselectNative(int windowHandle, int index);
	
	public int[] getSelectedIndexes() {
		return getNativeSelectedIndexes(getWindowHandle());
	}
	
	private native int[] getNativeSelectedIndexes(int windowHandle);
	
	public void makeVisible(int index) {
		makeNativeVisible(getWindowHandle(), index);
	}
	
	private native void makeNativeVisible(int windowHandle, int index);
	
	public Dimension minimumSize(int s) {
		return getMinimumSize(s);
	}
	
	public Dimension preferredSize(int s) {
		return getPreferredSize(s);
	}
	
	public void removeAll() {
		removeNativeAll(getWindowHandle());
	}
	
	private native void removeNativeAll(int windowHandle);
	
	public void select (int index) {
		selectNative(getWindowHandle(), index);
	}
	
	private native void selectNative(int windowHandle, int index);
	
	public void setMultipleMode(boolean multi) {
		setNativeMultipleMode(getWindowHandle(), multi);
	}
	
	private native void setNativeMultipleMode(int windowHandle, boolean multi);
	
	public void setMultipleSelections(boolean multi) {
		setMultipleMode(multi);
	}

	public Dimension getMinimumSize(int s) {
		return getNativeMinimumSize(getWindowHandle(), s);
	}
	
	private native Dimension getNativeMinimumSize(int windowHandle, int s);

	public Dimension getPreferredSize(int s) {
		return getNativePreferredSize(getWindowHandle(), s);
	}
	
	private native Dimension getNativePreferredSize(int windowHandle, int s);

	/**
	 * ActionEventpost
	 */
	protected void postActionEvent(int id,
								  int index,
								  long when,
								  int modifiers) {
		List list = (List) getComponent();
		queue.postEvent(
			new ActionEvent(list,
				   			id,
				   			list.getItem(index),
				   			System.currentTimeMillis(),
				   			modifiers)
			);
	}

	/**
	 * ItemEventpost
	 */
	protected void postItemEvent(int id,
								 int index,
								 int stateChange) {
		List list = (List) getComponent();
		queue.postEvent(
			new ItemEvent(list,
				   		  id,
				   		  new Integer(index),
				   		  stateChange)
			);
	}
}
