#include <windows.h>
#include <jni.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCEMenuPeer.h>

/*
 * Class:     gnu_java_awt_peer_wce_WCEMenuPeer
 * Method:    createNativeMenu
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_WCEMenuPeer_createNativeMenu(JNIEnv *env, jobject peer_obj) {
	// |bvAbvj[̃nhԂ
	return (jint) CreatePopupMenu();
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEMenuPeer
 * Method:    destroyNativeMenu
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEMenuPeer_destroyNativeMenu(JNIEnv *env, jobject peer_obj, jint menu_handle) {
	DestroyMenu((HMENU) menu_handle);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEMenuPeer
 * Method:    appendNative
 * Signature: (IILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEMenuPeer_appendNative(JNIEnv *env, jobject peer_obj, jint parentMenuHandle, jint menuHandle, jstring label) {
	BOOL b;
	_TCHAR* buff = get_string_chars(env, label);

	b = AppendMenu((HMENU) parentMenuHandle,
				MF_POPUP,
				(UINT) menuHandle,
				buff);
	if (! b) {
		jclass clazz = (*env)->FindClass(env, "java/awt/AWTError");
		if (clazz) {
			(*env)->ThrowNew(env, clazz, "AppendMenu() failed.");
		}
	}

	free(buff);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEMenuPeer
 * Method:    deleteNativeMenuItem
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEMenuPeer_deleteNativeMenuItem(JNIEnv *env, jobject peer_obj, jint menuHandle, jint index) {
	if (! DeleteMenu((HMENU) menuHandle,
				index,
				MF_BYPOSITION)) {
		jclass clazz = (*env)->FindClass(env, "java/awt/AWTError");
		if (clazz) {
			(*env)->ThrowNew(env, clazz, "DeleteMenu() failed.");
		}
	}
}
