/* gnu_java_awt_peer_wce_WCEOffscreenImage.c
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <windows.h>
#include <jni.h>
#include <assert.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCEOffscreenImage.h>

/*
 * Class:     gnu_java_awt_peer_wce_WCEOffscreenImage
 * Method:    createNativeBitmapHandle
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_WCEOffscreenImage_createNativeBitmapHandle(JNIEnv *env, jobject obj, jint windowHandle, jint width, jint height) {
	HDC hdc = GetDC((HWND) windowHandle);
	HBITMAP hbitmap = CreateCompatibleBitmap(hdc, width, height);

	// Windows Mobiile 5.0ł́A쐬rbg}bv̏l͕sɂȂĂ邽߁A
	// œhԂ
	if (hbitmap) {
		HDC hdcCompatible = CreateCompatibleDC(hdc);
		HBITMAP hOldBitmap = SelectObject(hdcCompatible, hbitmap);
		PatBlt(hdcCompatible, 0, 0, width, height, WHITENESS);
		SelectObject(hdc, hOldBitmap);
		DeleteDC(hdcCompatible);
	}

	ReleaseDC((HWND) windowHandle, hdc);

	return (jint) hbitmap;
}

