#include <windows.h>
#include <jni.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCEWindowPeer.h>

/*
 * Class:     gnu_java_awt_peer_wce_WCEWindowPeer
 * Method:    createNative
 * Signature: (IIIII)I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_WCEWindowPeer_createNative(JNIEnv *env, jobject peer_obj, jint parentWindowHandle, jint x, jint y, jint width, jint height) {
	peer_obj = (*env)->NewGlobalRef(env, peer_obj);
	if (! peer_obj) {
		throw_AWTError(env, "NewGlobalRef() failed.");
		return 0;
	}
	return (jint) create_native_window(peer_obj, (HWND) parentWindowHandle, x, y, width, height);	
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEWindowPeer
 * Method:    toNativeBack
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEWindowPeer_toNativeBack(JNIEnv *env, jobject peer_obj, jint windowHandle) {
	to_back(env, (HWND) windowHandle);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEWindowPeer
 * Method:    toNativeFront
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEWindowPeer_toNativeFront(JNIEnv *env, jobject peer_obj, jint windowHandle) {
	to_front(env, (HWND) windowHandle);
}
