<?php
// vim: foldmethod=marker
/**
 *  Ethna_Plugin.php
 *
 *  @author     ICHII Takashi <ichii386@schweetheart.jp>
 *  @author     Kazuhiro Hosoi <hosoi@gree.co.jp>
 *  @license    http://www.opensource.org/licenses/bsd-license.php The BSD License
 *  @package    Ethna
 *  @version    $Id: Ethna_Plugin.php,v 1.13 2006/11/28 04:52:54 ichii386 Exp $
 */

// {{{ Ethna_Plugin
/**
 *  ץ饰󥯥饹
 *  
 *  @author     ICHII Takashi <ichii386@schweetheart.jp>
 *  @author     Kazuhiro Hosoi <hosoi@gree.co.jp>
 *  @access     public
 *  @package    Ethna
 */
class Ethna_Plugin
{
    /**#@+
     *  @access private
     */

    /** @var    object  Ethna_Controller    ȥ饪֥ */
    var $controller;

    /** @var    object  Ethna_Controller    ȥ饪֥($controllerξά) */
    var $ctl;

    /** @var    object  Ethna_Logger        ֥ */
    var $logger;

    /** @var    array   ץ饰Υ֥(󥹥)¸ */
    var $obj_registry = array();

    /** @var    array   ץ饰Υ饹̾ե̾¸ */
    var $src_registry = array();

    /** @var    array       оݤȤʤץ饰ΥץꥱIDΥꥹ */
    var $appid_list;

    /**#@-*/

    // {{{ 󥹥ȥ饯
    /**
     *  Ethna_PluginΥ󥹥ȥ饯
     *
     *  @access public
     *  @param  object  Ethna_Controller    $controller ȥ饪֥
     */
    function Ethna_Plugin(&$controller)
    {
        $this->controller =& $controller;
        $this->ctl =& $this->controller;
        $this->logger = null;
        if (isset($this->controller->plugin_search_appids)
            && is_array($this->controller->plugin_search_appids)) {
            $this->appid_list =& $this->controller->plugin_search_appids;
        } else {
            $this->appid_list = array($this->controller->getAppId(), 'Ethna');
        }
    }

    /**
     *  loggerset롣
     *
     *  LogWriterpluginʤΤǡplugin󥹥󥹺Ǥ
     *  logger˰¸ʤ褦ˤ롣
     *
     *  @access public
     *  @param  object  Ethna_Logger    $logger ֥
     */
    function setLogger(&$logger)
    {
        if ($this->logger === null && is_object($logger)) {
            $this->logger =& $logger;
        }
    }
    // }}}

    // {{{ ץ饰ƤӽФ󥿥ե
    /**
     *  ץ饰Υ󥹥󥹤
     *
     *  @access public
     *  @param  string  $type   ץ饰μ
     *  @param  string  $name   ץ饰̾
     *  @return object  ץ饰Υ󥹥
     */
    function &getPlugin($type, $name)
    {
        return $this->_getPlugin($type, $name);
    }

    /**
     *   ($type) Υץ饰 ($name) ꥹȤ
     *
     *  @access public
     *  @param  string  $type   ץ饰μ
     *  @return array   ץ饰󥪥֥Ȥ
     */
    function getPluginList($type)
    {
        $plugin_list = array();

        $this->searchAllPluginSrc($type);
        if (isset($this->src_registry[$type]) == false) {
            return $plugin_list;
        }
        foreach ($this->src_registry[$type] as $name => $value) {
            if (is_null($value)) {
                continue;
            }
            $plugin_list[$name] =& $this->getPlugin($type, $name);
        }
        return $plugin_list;
    }
    // }}}

    // {{{ obj_registry Υ
    /**
     *  ץ饰Υ󥹥󥹤쥸ȥ꤫
     *
     *  @access private
     *  @param  string  $type   ץ饰μ
     *  @param  string  $name   ץ饰̾
     *  @return object  ץ饰Υ󥹥
     */
    function &_getPlugin($type, $name)
    {
        if (isset($this->obj_registry[$type]) == false) {
            $this->obj_registry[$type] = array();

            // ץ饰οƥ饹(¸ߤ)ɤ߹
            foreach ($this->appid_list as $appid) {
                list($class, $dir, $file) = $this->getPluginNaming($type, null, $appid);
                $this->_includePluginSrc($class, $dir, $file, true);
            }
        }

        // key ʤȤϥץ饰ɤ
        if (array_key_exists($name, $this->obj_registry[$type]) == false) {
            $this->_loadPlugin($type, $name);
        }

        // null ΤȤϥɤ˼ԤƤ
        if (is_null($this->obj_registry[$type][$name])) {
            return Ethna::raiseWarning('plugin [type=%s, name=%s] is not found', E_PLUGIN_NOTFOUND, $type, $name);
        }

        // ץ饰Υ󥹥󥹤֤
        return $this->obj_registry[$type][$name];
    }

    /**
     *  ץ饰includenew쥸ȥϿ
     *
     *  @access private
     *  @param  string  $type   ץ饰μ
     *  @param  string  $name   ץ饰̾
     */
    function _loadPlugin($type, $name)
    {
        // ץ饰Υե̾
        $plugin_src = $this->_getPluginSrc($type, $name);
        if (is_null($plugin_src)) {
            $this->obj_registry[$type][$name] = null;
            return;
        }
        list($plugin_class, $plugin_dir, $plugin_file) = $plugin_src;

        // ץ饰Υեɤ߹
        $r =& $this->_includePluginSrc($plugin_class, $plugin_dir, $plugin_file);
        if (Ethna::isError($r)) {
            $this->obj_registry[$type][$name] = null;
            return;
        }

        // ץ饰
        $instance =& new $plugin_class($this->controller, $type, $name);
        if (is_object($instance) == false
            || strcasecmp(get_class($instance), $plugin_class) != 0) {
            $this->logger->log(LOG_WARNING, 'plugin [%s::%s] instantiation failed', $type, $name);
            $this->obj_registry[$type][$name] = null;
            return;
        }
        $this->obj_registry[$type][$name] =& $instance;
    }

    /**
     *  ץ饰Υ󥹥󥹤쥸ȥ꤫ä
     *
     *  @access private
     *  @param  string  $type   ץ饰μ
     *  @param  string  $name   ץ饰̾
     */
    function _unloadPlugin($type, $name)
    {
        unset($this->obj_registry[$type][$name]);
    }
    // }}}

    // {{{ src_registry Υ
    /**
     *  ץ饰Υե̾ȥ饹̾쥸ȥ꤫
     *
     *  @access private
     *  @param  string  $type   ץ饰μ
     *  @param  string  $name   ץ饰̾
     *  @return array   ե̾ȥ饹̾ʤ
     */
    function _getPluginSrc($type, $name)
    {
        if (isset($this->src_registry[$type]) == false) {
            $this->src_registry[$type] = array();
        }

        // key ʤȤϥץ饰θ򤹤
        if (array_key_exists($name, $this->src_registry[$type]) == false) {
            $this->_searchPluginSrc($type, $name);
        }

        // ץ饰Υ֤
        return $this->src_registry[$type][$name];
    }
    // }}}

    // {{{ ץ饰ե븡ʬ
    /**
     *  ץ饰Υ饹̾ǥ쥯ȥꡢե̾
     *
     *  @access public
     *  @param  string  $type   ץ饰μ
     *  @param  string  $name   ץ饰̾ (nullΤȤϿƥ饹)
     *  @param  string  $appid  ץꥱID
     *  @return array   ץ饰Υ饹̾ǥ쥯ȥꡢե̾
     *  @todo   class factorynaming rule礵
     */
    function getPluginNaming($type, $name, $appid)
    {
        if ($appid == 'Ethna') {
            if ($name === null) {
                $ext = 'php';
                $dir = ETHNA_BASE . "/class/Plugin";
                $class = "Ethna_Plugin_{$type}";
            } else {
                $ext = 'php';
                $dir = ETHNA_BASE . "/class/Plugin/{$type}";
                $class = "Ethna_Plugin_{$type}_{$name}";
            }
        } else {
            if ($name === null) {
                $ext = $this->controller->getExt('php');
                $dir = $this->controller->getDirectory('plugin');
                $class = "{$appid}_Plugin_{$type}";
            } else {
                $ext = $this->controller->getExt('php');
                $dir = $this->controller->getDirectory('plugin') . "/{$type}";
                $class = "{$appid}_Plugin_{$type}_{$name}";
            }
        }

        $file  = "{$class}.{$ext}";
        return array($class, $dir, $file);
    }

    /**
     *  ץ饰Υ include 
     *
     *  @access private
     *  @param  string  $class  饹̾
     *  @param  string  $dir    ǥ쥯ȥ̾
     *  @param  string  $file   ե̾
     *  @param  bool    $parent ƥ饹ɤΥե饰
     *  @return true|Ethna_Error
     */
    function &_includePluginSrc($class, $dir, $file, $parent = false)
    {
        $true = true;
        $file = $dir . '/' . $file;

        if (file_exists($file) === false) {
            if ($parent === false) {
                return Ethna::raiseWarning('plugin file is not found: [%s]',
                                           E_PLUGIN_NOTFOUND, $file);
            } else {
                return $true;
            }
        }

        include_once $file;

        if (class_exists($class) === false) {
            if ($parent === false) {
                return Ethna::raiseWarning('plugin class [%s] is not defined', E_PLUGIN_NOTFOUND, $class);
            } else {
                return $true;
            }
        }

        if ($parent === false) {
            $this->logger->log(LOG_DEBUG, 'plugin class [%s] is defined', $class);
        }
        return $true;
    }

    /**
     *  ץꥱ, Ethna νǥץ饰Υ򸡺
     *
     *  @access private
     *  @param  string  $type   ץ饰μ
     *  @param  string  $name   ץ饰̾
     */
    function _searchPluginSrc($type, $name)
    {
        // ȥǻꤵ줿ץꥱIDν˸
        foreach ($this->appid_list as $appid) {
            list($class, $dir, $file) = $this->getPluginNaming($type, $name, $appid);
            if (file_exists("{$dir}/{$file}")) {
                $this->logger->log(LOG_DEBUG, 'plugin file is found in search: [%s]',
                                   "{$dir}/{$file}");
                if (isset($this->src_registry[$type]) == false) {
                    $this->src_registry[$type] = array();
                }
                $this->src_registry[$type][$name] = array($class, $dir, $file);
                return;
            }
        }

        // Ĥʤä (nullǵƤ)
        $this->logger->log(LOG_WARNING, 'plugin file for [type=%s, name=%s] is not found in search', $type, $name);
        $this->src_registry[$type][$name] = null;
    }

    /**
     *  ץ饰μ ($type) 򤹤٤Ƹ
     *
     *  @access public
     *  @return array
     */
    function searchAllPluginType()
    {
        $type_list = array();
        foreach (array_reverse($this->appid_list) as $appid) {
            list(, $dir, ) = $this->getPluginNaming('', null, $appid);
            if (is_dir($dir) == false) {
                continue;
            }
            $dh = opendir($dir);
            if (is_resource($dh) == false) {
                continue;
            }
            while (($type_dir = readdir($dh)) !== false) {
                if ($type_dir{0} != '.' && is_dir("{$dir}/{$type_dir}")) {
                    $type_list[$type_dir] = 0;
                }
            }
            closedir($dh);
        }
        return array_keys($type_list);
    }

    /**
     *  ꤵ줿 $type Υץ饰 (Υ) 򤹤٤Ƹ
     *
     *  @access public
     *  @param  string  $type   ץ饰μ
     */
    function searchAllPluginSrc($type)
    {
        // ǸդäΤǾ񤭤Τ $this->appid_list εսȤ
        $name_list = array();
        foreach (array_reverse($this->appid_list) as $appid) {
            list($class_regexp, $dir, $file_regexp) = $this->getPluginNaming($type, '([^_]+)', $appid);

            //ǥ쥯ȥ¸ߤΥå
            if (is_dir($dir) == false) {
                // ץ¦ǸդʤΤ
                continue;
            }

            // ǥ쥯ȥ򳫤
            $dh = opendir($dir);
            if (is_resource($dh) == false) {
                $this->logger->log(LOG_DEBUG, 'cannot open plugin directory: [%s]', $dir);
                continue;
            }
            $this->logger->log(LOG_DEBUG, 'plugin directory opened: [%s]', $dir);

            // ˤ $name ꥹȤɲ
            while (($file = readdir($dh)) !== false) {
                if (preg_match('#^'.$file_regexp.'$#', $file, $matches)
                    && file_exists("{$dir}/{$file}")) {
                    $name_list[$matches[1]] = true;
                }
            }

            closedir($dh);
        }

        foreach (array_keys($name_list) as $name) {
            // Ĺ⤦õʤ
            $this->_searchPluginSrc($type, $name);
        }
    }
    // }}}

    // {{{ static  include ᥽å
    /**
     *  Ethna °Υץ饰Υ include 
     *
     *  @access public
     *  @param  string  $type   ץ饰μ
     *  @param  string  $name   ץ饰̾
     *  @static
     */
    function includeEthnaPlugin($type, $name)
    {
        Ethna_Plugin::includePlugin($type, $name, 'Ethna');
    }

    /**
     *  ץ饰Υ include 
     *
     *  @access public
     *  @param  string  $type   ץ饰μ
     *  @param  string  $name   ץ饰̾
     *  @param  string  $appid  ץꥱID
     *  @static
     */
    function includePlugin($type, $name, $appid = null)
    {
        $ctl =& Ethna_Controller::getInstance();
        $plugin =& $ctl->getPlugin();

        if ($appid === null) {
            $appid = $ctl->getAppId();
        }
        list($class, $dir, $file) = $plugin->getPluginNaming($type, $name, $appid);
        $plugin->_includePluginSrc($class, $dir, $file);
    }
    // }}}
}
// }}}
?>
