<?php
/**
 *  Ethna_Plugin_Validator_Required_Test.php
 */

/**
 *  Ethna_Plugin_Validator_Required饹Υƥȥ
 *
 *  @access public
 */
class Ethna_Plugin_Csrf_Session_Test extends Ethna_UnitTestBase
{
    /**
     * Description of the Variable
     * @var     Ethna_Plugin_Csrf_Session
     * @access  private
     */
    var $csrf;

    function testMakeInstance()
    {
        $ctl =& Ethna_Controller::getInstance();
        $plugin =& $ctl->getPlugin();
        $this->csrf =& $plugin->getPlugin('Csrf', 'Session');
        $this->assertTrue(is_object($this->csrf), 'getPlugin failed');
        $this->csrf->session =& new Ethna_Session_Dummy($ctl->appid, '',  $ctl->getLogger());
    }

    function testGetName()
    {
        $this->assertTrue(strlen($this->csrf->getName()), 'token name not found');
    }

    function testCheckCsrfSession()
    {
        $this->assertTrue($this->csrf->set());
        $this->csrfid = $this->csrf->get();
    }

    function testPostRequest()
    {
        $_SERVER['REQUEST_METHOD'] = "post";
        $_POST[$this->csrf->getName()] = "";
        $this->assertFalse($this->csrf->isValid());

        $_POST[$this->csrf->getName()] = $this->csrfid;
        $this->assertTrue($this->csrf->isValid());
    }

    function testGetRequest()
    {
        $_SERVER['REQUEST_METHOD'] = "get";
        $_GET[$this->csrf->getName()] = "";
        $this->assertFalse($this->csrf->isValid());

        $_GET[$this->csrf->getName()] = $this->csrfid;
        $this->assertTrue($this->csrf->isValid());
    }

}

/**
 *  SessionClass_Dummy
 *
 *  @access public
 */
// {{{ Ethna_Session
/**
 *  å󥯥饹Υߡ
 *
 *  @author     Keita Arai <cocoiti@comio.info>
 *  @access     public
 *  @package    Ethna
 */
class Ethna_Session_Dummy extends Ethna_Session
{
    var $dummy_session = array();


    /**
     *  å
     *
     *  @access public
     */
    function restore()
    {
        $this->session_start = true;
        return true;
    }

    /**
     *  åå
     *
     *  @access public
     *  @return bool    true:ʥå false:ʥå
     */
    function isValid()
    {
        return true;
    }

    /**
     *  å򳫻Ϥ
     *
     *  @access public
     *  @param  int     $lifetime   åͭ(ñ, 0ʤ饻å󥯥å)
     *  @return bool    true:ｪλ false:顼
     */
    function start($lifetime = 0, $anonymous = false)
    {
        $_SESSION['REMOTE_ADDR'] = "DUMMY";
        $_SESSION['__anonymous__'] = $anonymous;
        $this->session_start = true;
        return true;
    }

    /**
     *  å˴
     *
     *  @access public
     *  @return bool    true:ｪλ false:顼
     */
    function destroy()
    {
        return true;
    }

    /**
     *  åͤؤΥ(R)
     *
     *  @access public
     *  @param  string  $name   
     *  @return mixed   (null:å󤬳ϤƤʤ)
     */
    function get($name)
    {
        if (!isset($this->dummy_session[$name])) {
            return null;
        }
        return $this->dummy_session[$name];
    }

    /**
     *  åͤؤΥ(W)
     *
     *  @access public
     *  @param  string  $name   
     *  @param  string  $value  
     *  @return bool    true:ｪλ false:顼(å󤬳ϤƤʤ)
     */
    function set($name, $value)
    {
        if (!$this->session_start) {
            // no way
            return false;
        }

        $this->dummy_session[$name] = $value;

        return true;
    }

    /**
     *  åͤ˴
     *
     *  @access public
     *  @param  string  $name   
     *  @return bool    true:ｪλ false:顼(å󤬳ϤƤʤ)
     */
    function remove($name)
    {
        if (!$this->session_start) {
            return false;
        }

        unset($this->dummy_session[$name]);

        return true;
    }
}
// }}}

?>
