/*
 * Decompiled with CFR 0.152.
 */
package org.yanroncha.n3.resource.xml.node;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.yanroncha.n3.resource.xml.N3XmlConverter;
import org.yanroncha.n3.resource.xml.node.Html2N3Article;

public abstract class Node {
    protected static String PARAGRAPH_SEP = ":";
    protected static String PAGE_SEP = "@";
    protected static final String NULL_OBJECT = "null";
    protected static final String KC_TYPE = "type";
    protected static final String TC_LOCATION = "location";
    protected static final String TC_NAVI = "navi";
    protected static final String TC_PAGE = "page";
    protected static final String TC_PARAGRAPH = "paragraph";
    protected static final String TC_NO_BREAK = "no_break";
    protected static final String TC_NO_DECODE = "no_decode";
    protected static N3XmlConverter xmlConverter = null;
    private static Value targetValue = null;
    private static Pattern LocalePattern = null;
    private static Pattern TagPattern = null;
    private static ArrayList<Value> decodings = new ArrayList();
    private HashMap<String, Value> values = new HashMap();

    public static void setConverter(N3XmlConverter n3XmlConverter) {
        xmlConverter = n3XmlConverter;
    }

    public static int[] getTargetValueLocation() {
        int[] nArray = new int[2];
        if (targetValue != null) {
            nArray[0] = Node.targetValue.line;
            nArray[1] = Node.targetValue.col;
        } else {
            nArray[1] = -1;
            nArray[0] = -1;
        }
        return nArray;
    }

    public static String valueToLocation(Node node, String string, String string2) throws Exception {
        String[] stringArray = string2.split(PARAGRAPH_SEP);
        String[] stringArray2 = stringArray[0].split(PAGE_SEP);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (stringArray.length == 1 && stringArray2.length == 1) {
            stringBuilder.append(xmlConverter.getNaviItemLocation(string2));
            stringBuilder.append(",-1,0]");
        } else if (stringArray.length == 1 && stringArray2.length == 2) {
            stringBuilder.append(xmlConverter.getContentsLocation(stringArray[0]));
            stringBuilder.append(",0]");
        } else if (stringArray.length == 2 && stringArray2.length == 2) {
            stringBuilder.append(xmlConverter.getContentsLocation(stringArray[0]));
            stringBuilder.append(',');
            stringBuilder.append(xmlConverter.getParagraphIndex(stringArray2[0], stringArray[1]));
            stringBuilder.append(']');
        } else {
            throw new N3XmlConverter.WrongParameterValueException(node, string, string2);
        }
        return stringBuilder.toString();
    }

    public static void decodeValues() {
        int n = decodings.size();
        for (int i = 0; i < n; ++i) {
            decodings.get(i).parse();
        }
    }

    public Node(Attributes attributes) {
    }

    protected Set<String> getValueKeys() {
        return this.values.keySet();
    }

    protected Value getValueObj(String string) {
        return this.values.get(string);
    }

    protected String getValue(String string) {
        Value value = this.values.get(string);
        if (value != null) {
            return value.val;
        }
        return null;
    }

    protected int getValuesCount() {
        return this.values.size();
    }

    public void setValue(String string, String string2, String string3) throws Exception {
        Object object;
        boolean bl = false;
        if (string2.length() > 1) {
            object = new StringBuilder(string2);
            int n = ((StringBuilder)object).length() - 1;
            char c = ((StringBuilder)object).charAt(0);
            char c2 = ((StringBuilder)object).charAt(n);
            if (c == '[') {
                if (c2 != ']') {
                    throw new N3XmlConverter.WrongParameterValueException(this, string, string2);
                }
            } else if (c == '\"') {
                if (c2 != '\"') {
                    throw new N3XmlConverter.WrongParameterValueException(this, string, string2);
                }
                bl = true;
            }
        }
        object = xmlConverter.getLocator();
        this.values.put(string, new Value(this, string2, string3, bl, object.getLineNumber(), object.getColumnNumber()));
    }

    public String fetchValue(String string) {
        try {
            return this.values.remove((Object)string).val;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void checkNecessaryValues(Node node, String ... stringArray) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (node.getValueObj(string) != null) continue;
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((String)arrayList.get(i));
            }
            throw new N3XmlConverter.NecessaryParameterLackedException(node, stringBuilder.toString());
        }
    }

    protected String getParagraphLocation(String string) {
        String[] stringArray = string.split(PARAGRAPH_SEP);
        if (stringArray.length == 2) {
            int n = xmlConverter.getPageIndex(stringArray[0]);
            int n2 = xmlConverter.getParagraphIndex(stringArray[0], stringArray[1]);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            stringBuilder.append(n);
            stringBuilder.append(',');
            stringBuilder.append(n2);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
        return null;
    }

    public void writeValues(PrintWriter printWriter, int n) throws Exception {
        String string = xmlConverter.getIndent();
        Set<String> set = this.getValueKeys();
        int n2 = set.size();
        int n3 = 1;
        for (String string2 : set) {
            Object object;
            Value value = targetValue = this.getValueObj(string2);
            String string3 = value.val;
            if (string3 == null || string3.length() == 0) {
                string3 = NULL_OBJECT;
            } else if (TC_NAVI.equals(value.type)) {
                object = new StringBuilder();
                ((StringBuilder)object).append('[');
                ((StringBuilder)object).append(xmlConverter.getNaviItemLocation(string3));
                ((StringBuilder)object).append(']');
                string3 = ((StringBuilder)object).toString();
            } else if (TC_LOCATION.equals(value.type)) {
                string3 = Node.valueToLocation(this, string2, string3);
            } else if (TC_PAGE.equals(value.type)) {
                int n4 = xmlConverter.getPageIndex(string3);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('[');
                stringBuilder.append(Integer.toString(n4));
                stringBuilder.append(']');
                string3 = stringBuilder.toString();
            } else if (TC_PARAGRAPH.equals(value.type)) {
                if ((string3 = this.getParagraphLocation(string3)) == null) {
                    throw new N3XmlConverter.WrongParameterValueException(this, string2, string3);
                }
            } else if (value.decode && string3.charAt(0) == '[') {
                object = LocalePattern.matcher(string2);
                string2 = ((Matcher)object).find() ? "__" + ((Matcher)object).group(1) : "_";
            }
            if (KC_TYPE.equals(string2)) {
                string2 = "0";
            }
            printWriter.printf("%s%s: %s", string, string2, string3);
            if (n3 < n2 || n > 0) {
                printWriter.print(",\n");
            } else {
                printWriter.print("\n");
            }
            ++n3;
        }
    }

    public abstract Node setSubNode(String var1, Attributes var2) throws Exception;

    public Node quitNode(String string) throws Exception {
        return null;
    }

    public abstract void writeData(PrintWriter var1, int var2) throws Exception;

    static {
        Locale[] localeArray = Locale.getAvailableLocales();
        HashSet<String> hashSet = new HashSet<String>();
        int n = localeArray.length;
        for (int i = 0; i < n; ++i) {
            hashSet.add(localeArray[i].getLanguage());
        }
        StringBuilder stringBuilder = new StringBuilder("_(");
        Iterator iterator = hashSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            if (n2 > 0) {
                stringBuilder.append('|');
            }
            stringBuilder.append((String)iterator.next());
            ++n2;
        }
        stringBuilder.append(")$");
        LocalePattern = Pattern.compile(stringBuilder.toString());
        TagPattern = Pattern.compile("<\".*?\"|'.*?'|[^'\"]*?>");
    }

    private class Value
    implements Html2N3Article.ConvertedCallback {
        Node node;
        String val;
        String type;
        int line;
        int col;
        boolean decode = false;

        public Value(Node node2, String string, String string2, boolean bl, int n, int n2) {
            Object object;
            this.node = node2;
            this.val = string;
            this.type = string2;
            this.line = n;
            this.col = n2;
            if (Node.TC_NO_BREAK.equals(string2)) {
                this.val = string.replaceAll("\\\n", "");
            } else if (bl) {
                if (Node.TC_NO_DECODE.equals(string2)) {
                    this.val = string.replaceAll("\\\n", "\\\\n");
                } else {
                    this.val = string.replaceAll("\\\n", "<br>");
                    if (string2 == null && ((Matcher)(object = TagPattern.matcher(this.val))).find()) {
                        this.decode = true;
                        decodings.add(this);
                    }
                }
            }
            if (bl && !this.decode) {
                object = new StringBuilder(this.val);
                ((StringBuilder)object).deleteCharAt(((StringBuilder)object).length() - 1);
                ((StringBuilder)object).deleteCharAt(0);
                String string3 = ((StringBuilder)object).toString();
                string3 = string3.replaceAll("\\\\", "\\\\\\\\");
                string3 = string3.replaceAll("\\\"", "\\\\\"");
                object = new StringBuilder().append('\"').append(string3).append('\"');
                this.val = ((StringBuilder)object).toString();
            }
        }

        public void parse() {
            new Html2N3Article(this.node, this.val.substring(1, this.val.length() - 1), true, this).invoke();
        }

        @Override
        public void converted(String string, boolean bl) {
            this.val = string;
        }
    }

    public static class NodeFormInfo {
        String name;
        HashMap<String, Class<? extends Node>> subNodeMap;
        HashSet<String> innerSubNodes;
        HashSet<String> prmNodes;
        HashSet<String> keywords;

        public NodeFormInfo(String string) {
            this.name = string;
            this.subNodeMap = new HashMap();
            this.innerSubNodes = new HashSet();
            this.prmNodes = new HashSet();
            this.keywords = new HashSet();
        }

        public void regSubNode(String string, Class<? extends Node> clazz) {
            this.subNodeMap.put(string, clazz);
            N3XmlConverter.initNodeClass(clazz);
        }

        public Node getSubNode(String string, Attributes attributes) {
            try {
                Class<? extends Node> clazz = this.subNodeMap.get(string);
                Constructor<? extends Node> constructor = clazz.getConstructor(Attributes.class);
                return constructor.newInstance(attributes);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public String getName() {
            return this.name;
        }

        public Class<? extends Node> getSubNodeClass(String string) {
            return this.subNodeMap.get(string);
        }

        public void regInnerSubNode(String string) {
            this.innerSubNodes.add(string);
        }

        public boolean isInnerSubNode(String string) {
            return this.innerSubNodes.contains(string);
        }

        public void regPrmNode(String string) {
            this.prmNodes.add(string);
        }

        public boolean isPrmNode(String string) {
            return this.prmNodes.contains(string);
        }

        public void regKeyword(String string) {
            this.keywords.add(string);
        }

        public boolean isKeyword(String string) {
            return this.keywords.contains(string);
        }
    }
}

