/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.GeneratorStrategy;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Dispatcher;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.transform.impl.UndeclaredThrowableStrategy;
import org.aopalliance.aop.AspectException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopContext;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.ReflectiveMethodInvocation;

public class Cglib2AopProxy
implements AopProxy,
Serializable {
    private static final int AOP_PROXY = 0;
    private static final int INVOKE_TARGET = 1;
    private static final int NO_OVERRIDE = 2;
    private static final int DISPATCH_TARGET = 3;
    private static final int DISPATCH_ADVISED = 4;
    private static final int INVOKE_EQUALS = 5;
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$aop$framework$Cglib2AopProxy == null ? (class$org$springframework$aop$framework$Cglib2AopProxy = Cglib2AopProxy.class$("org.springframework.aop.framework.Cglib2AopProxy")) : class$org$springframework$aop$framework$Cglib2AopProxy));
    private final transient AdvisedDispatcher advisedDispatcher = new AdvisedDispatcher();
    private transient int fixedInterceptorOffset;
    private transient Map fixedInterceptorMap;
    protected AdvisedSupport advised;
    static /* synthetic */ Class class$org$springframework$aop$framework$Cglib2AopProxy;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$reflect$UndeclaredThrowableException;
    static /* synthetic */ Class class$org$springframework$aop$framework$Advised;

    protected Cglib2AopProxy(AdvisedSupport config) throws AopConfigException {
        if (config == null) {
            throw new AopConfigException("Cannot create AopProxy with null ProxyConfig");
        }
        if (config.getAdvisors().length == 0 && config.getTargetSource() == AdvisedSupport.EMPTY_TARGET_SOURCE) {
            throw new AopConfigException("Cannot create AopProxy with no advisors and no target source");
        }
        this.advised = config;
        if (this.advised.getTargetSource().getTargetClass() == null) {
            throw new AopConfigException("Either an interface or a target is required for proxy creation");
        }
    }

    protected static Object massageReturnTypeIfNecessary(Object proxy, Object target, Object retVal) {
        if (retVal != null && retVal == target) {
            retVal = proxy;
        }
        return retVal;
    }

    protected final boolean isEqualsMethod(Method m) {
        return "equals".equals(m.getName()) && m.getParameterTypes().length == 1 && m.getParameterTypes()[0] == (class$java$lang$Object == null ? (class$java$lang$Object = Cglib2AopProxy.class$("java.lang.Object")) : class$java$lang$Object);
    }

    public Object getProxy() {
        return this.getProxy(Thread.currentThread().getContextClassLoader());
    }

    public Object getProxy(ClassLoader cl) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating CGLIB proxy for [" + this.advised.getTargetSource().getTargetClass() + "]"));
        }
        Enhancer e = new Enhancer();
        try {
            Class rootClass = this.advised.getTargetSource().getTargetClass();
            e.setSuperclass(rootClass);
            e.setCallbackFilter((CallbackFilter)new ProxyCallbackFilter(this.advised));
            e.setStrategy((GeneratorStrategy)new UndeclaredThrowableStrategy(class$java$lang$reflect$UndeclaredThrowableException == null ? (class$java$lang$reflect$UndeclaredThrowableException = Cglib2AopProxy.class$("java.lang.reflect.UndeclaredThrowableException")) : class$java$lang$reflect$UndeclaredThrowableException));
            e.setInterfaces(AopProxyUtils.completeProxiedInterfaces(this.advised));
            Callback[] callbacks = this.getCallbacks(rootClass);
            e.setCallbacks(callbacks);
            Class[] types = new Class[callbacks.length];
            for (int x = 0; x < types.length; ++x) {
                types[x] = callbacks[x].getClass();
            }
            e.setCallbackTypes(types);
            return e.create();
        }
        catch (CodeGenerationException ex) {
            throw new AspectException("Couldn't generate CGLIB subclass of class '" + this.advised.getTargetSource().getTargetClass() + "': " + "Common causes of this problem include using a final class, or a non-visible class", (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new AspectException("Couldn't generate CGLIB subclass of class '" + this.advised.getTargetSource().getTargetClass() + "': " + "Common causes of this problem include using a final class, or a non-visible class", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new AspectException("Unexpected AOP exception", (Throwable)ex);
        }
    }

    private Callback[] getCallbacks(Class rootClass) throws Exception {
        Callback[] callbacks;
        boolean exposeProxy = this.advised.getExposeProxy();
        boolean isFrozen = this.advised.isFrozen();
        boolean isStatic = this.advised.getTargetSource().isStatic();
        DynamicAdvisedInterceptor aopInterceptor = new DynamicAdvisedInterceptor();
        MethodInterceptor targetInterceptor = null;
        targetInterceptor = exposeProxy ? (isStatic ? new StaticUnadvisedExposedInterceptor(this.advised.getTargetSource().getTarget()) : new DynamicUnadvisedExposedInterceptor()) : (isStatic ? new StaticUnadvisedInterceptor(this.advised.getTargetSource().getTarget()) : new DynamicUnadvisedInterceptor());
        Serializable targetDispatcher = isStatic ? new StaticDispatcher(this.advised.getTargetSource().getTarget()) : new NoOp();
        Callback[] mainCallbacks = new Callback[]{aopInterceptor, targetInterceptor, new NoOp(), targetDispatcher, this.advisedDispatcher, new EqualsInterceptor(this.advised)};
        if (isStatic && isFrozen) {
            int x;
            Callback[] fixedCallbacks = null;
            Method[] methods = rootClass.getMethods();
            fixedCallbacks = new Callback[methods.length];
            this.fixedInterceptorMap = new HashMap();
            for (x = 0; x < methods.length; ++x) {
                List chain = this.advised.getAdvisorChainFactory().getInterceptorsAndDynamicInterceptionAdvice(this.advised, null, methods[x], rootClass);
                fixedCallbacks[x] = new FixedChainStaticTargetInterceptor(chain, this.advised.getTargetSource().getTarget());
                this.fixedInterceptorMap.put(methods[x].toString(), new Integer(x));
            }
            callbacks = new Callback[mainCallbacks.length + fixedCallbacks.length];
            for (x = 0; x < mainCallbacks.length; ++x) {
                callbacks[x] = mainCallbacks[x];
            }
            for (x = 0; x < fixedCallbacks.length; ++x) {
                callbacks[x + mainCallbacks.length] = fixedCallbacks[x];
            }
            this.fixedInterceptorOffset = mainCallbacks.length;
        } else {
            callbacks = mainCallbacks;
        }
        return callbacks;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        Cglib2AopProxy otherCglibProxy = null;
        if (!(other instanceof Cglib2AopProxy)) {
            return false;
        }
        otherCglibProxy = (Cglib2AopProxy)other;
        return AopProxyUtils.equalsInProxy(this.advised, otherCglibProxy.advised);
    }

    public int hashCode() {
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MethodInvocationImpl
    extends ReflectiveMethodInvocation {
        private final MethodProxy methodProxy;

        public MethodInvocationImpl(Object proxy, Object target, Method m, Object[] arguments, Class targetClass, List interceptorsAndDynamicMethodMatchers, MethodProxy methodProxy) {
            super(proxy, target, m, arguments, targetClass, interceptorsAndDynamicMethodMatchers);
            this.methodProxy = methodProxy;
        }

        protected Object invokeJoinpoint() throws Throwable {
            return this.methodProxy.invoke(this.target, this.arguments);
        }
    }

    private class NoOp
    implements net.sf.cglib.proxy.NoOp,
    Serializable {
        private NoOp() {
        }
    }

    private class ProxyCallbackFilter
    implements CallbackFilter {
        private final AdvisedSupport advised;

        public ProxyCallbackFilter(AdvisedSupport advised) {
            this.advised = advised;
        }

        public int accept(Method method) {
            if (method.getDeclaringClass() == (class$java$lang$Object == null ? (class$java$lang$Object = Cglib2AopProxy.class$("java.lang.Object")) : class$java$lang$Object) && method.getName().equals("finalize")) {
                logger.info((Object)"Object.finalize () method found - using NO_OVERRIDE");
                return 2;
            }
            if (method.getDeclaringClass() == (class$org$springframework$aop$framework$Advised == null ? (class$org$springframework$aop$framework$Advised = Cglib2AopProxy.class$("org.springframework.aop.framework.Advised")) : class$org$springframework$aop$framework$Advised)) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Method " + method + " is declared on Advised - using DISPATCH_ADVISED"));
                }
                return 4;
            }
            if (Cglib2AopProxy.this.isEqualsMethod(method)) {
                logger.info((Object)"Found equals() method - using INVOKE_EQUALS");
                return 5;
            }
            Class targetClass = this.advised.getTargetSource().getTargetClass();
            List chain = this.advised.getAdvisorChainFactory().getInterceptorsAndDynamicInterceptionAdvice(this.advised, null, method, targetClass);
            boolean haveAdvice = !chain.isEmpty();
            boolean exposeProxy = this.advised.getExposeProxy();
            boolean isStatic = this.advised.getTargetSource().isStatic();
            boolean isFrozen = this.advised.isFrozen();
            if (haveAdvice) {
                if (exposeProxy) {
                    return 0;
                }
                String key = method.toString();
                if (isStatic && isFrozen && Cglib2AopProxy.this.fixedInterceptorMap.containsKey(key)) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Method " + method + " has Advice and optimisations are enabled - using specific FixedChainStaticTargetInterceptor"));
                    }
                    int index = (Integer)Cglib2AopProxy.this.fixedInterceptorMap.get(key);
                    return index + Cglib2AopProxy.this.fixedInterceptorOffset;
                }
                return 0;
            }
            if (exposeProxy || !isStatic) {
                return 1;
            }
            Class<?> returnType = method.getReturnType();
            if (targetClass == returnType) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Method " + method + "has return type same as target type (may return this) - using INVOKE_TARGET"));
                }
                return 1;
            }
            if (returnType.isPrimitive() || !returnType.isAssignableFrom(targetClass)) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Method " + method + "has return type that ensures this cannot be returned- using DISPATCH_TARGET"));
                }
                return 3;
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Method " + method + "has return type that is assignable from the target type (may return this) - using INVOKE_TARGET"));
            }
            return 1;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            ProxyCallbackFilter otherCallbackFilter = null;
            if (!(other instanceof ProxyCallbackFilter)) {
                return false;
            }
            otherCallbackFilter = (ProxyCallbackFilter)other;
            if (this.advised.isFrozen() != otherCallbackFilter.advised.isFrozen()) {
                return false;
            }
            if (this.advised.getExposeProxy() != otherCallbackFilter.advised.getExposeProxy()) {
                return false;
            }
            if (this.advised.getTargetSource().isStatic() != otherCallbackFilter.advised.getTargetSource().isStatic()) {
                return false;
            }
            return AopProxyUtils.equalsProxiedInterfaces(this.advised, otherCallbackFilter.advised) & AopProxyUtils.equalsAdvisors(this.advised, otherCallbackFilter.advised);
        }
    }

    private class DynamicAdvisedInterceptor
    implements MethodInterceptor,
    Serializable {
        private DynamicAdvisedInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object object;
            boolean setProxyContext;
            Object oldProxy;
            block8: {
                MethodInvocationImpl invocation = null;
                oldProxy = null;
                setProxyContext = false;
                Class<?> targetClass = null;
                Object target = null;
                try {
                    List chain;
                    Object retVal = null;
                    target = this.getTarget();
                    if (target != null) {
                        targetClass = target.getClass();
                    }
                    if (Cglib2AopProxy.this.advised.exposeProxy) {
                        oldProxy = AopContext.setCurrentProxy(proxy);
                        setProxyContext = true;
                    }
                    if ((chain = Cglib2AopProxy.this.advised.getAdvisorChainFactory().getInterceptorsAndDynamicInterceptionAdvice(Cglib2AopProxy.this.advised, proxy, method, targetClass)).isEmpty()) {
                        retVal = methodProxy.invoke(target, args);
                    } else {
                        invocation = new MethodInvocationImpl(proxy, target, method, args, targetClass, chain, methodProxy);
                        retVal = invocation.proceed();
                    }
                    object = retVal = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, target, retVal);
                    Object var14_13 = null;
                    if (target == null) break block8;
                }
                catch (Throwable throwable) {
                    block9: {
                        Object var14_14 = null;
                        if (target != null) {
                            this.releaseTarget(target);
                        }
                        if (!setProxyContext) break block9;
                        AopContext.setCurrentProxy(oldProxy);
                    }
                    throw throwable;
                }
                this.releaseTarget(target);
            }
            if (setProxyContext) {
                AopContext.setCurrentProxy(oldProxy);
            }
            return object;
        }

        public int hashCode() {
            return Cglib2AopProxy.this.advised.hashCode();
        }

        protected Object getTarget() throws Exception {
            return Cglib2AopProxy.this.advised.getTargetSource().getTarget();
        }

        protected void releaseTarget(Object target) throws Exception {
            Cglib2AopProxy.this.advised.getTargetSource().releaseTarget(target);
        }
    }

    private static class FixedChainStaticTargetInterceptor
    implements MethodInterceptor,
    Serializable {
        private final List adviceChain;
        private final Object target;
        private final Class targetClass;

        public FixedChainStaticTargetInterceptor(List adviceChain, Object target) {
            this.adviceChain = adviceChain;
            this.target = target;
            this.targetClass = target.getClass();
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            MethodInvocationImpl invocation = null;
            Object retVal = null;
            invocation = new MethodInvocationImpl(proxy, this.target, method, args, this.targetClass, this.adviceChain, methodProxy);
            retVal = invocation.proceed();
            retVal = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, this.target, retVal);
            return retVal;
        }
    }

    private class EqualsInterceptor
    implements MethodInterceptor,
    Serializable {
        private AdvisedSupport advised;

        private EqualsInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Callback callback;
            Object other = args[0];
            if (other == null) {
                return Boolean.FALSE;
            }
            if (other == proxy) {
                return Boolean.TRUE;
            }
            AdvisedSupport otherAdvised = null;
            if (other instanceof Factory) {
                callback = ((Factory)other).getCallback(5);
                if (!(callback instanceof EqualsInterceptor)) {
                    return Boolean.FALSE;
                }
            } else {
                return Boolean.FALSE;
            }
            otherAdvised = ((EqualsInterceptor)callback).advised;
            return AopProxyUtils.equalsInProxy(this.advised, otherAdvised);
        }
    }

    private class AdvisedDispatcher
    implements Dispatcher,
    Serializable {
        private AdvisedDispatcher() {
        }

        public Object loadObject() throws Exception {
            return Cglib2AopProxy.this.advised;
        }
    }

    private class DynamicDispatcher
    implements Dispatcher,
    Serializable {
        private DynamicDispatcher() {
        }

        public Object loadObject() throws Exception {
            return Cglib2AopProxy.this.advised.getTargetSource().getTarget();
        }
    }

    private static class StaticDispatcher
    implements Dispatcher,
    Serializable {
        private Object target;

        public StaticDispatcher(Object target) {
            this.target = target;
        }

        public Object loadObject() {
            return this.target;
        }
    }

    private class DynamicUnadvisedExposedInterceptor
    implements MethodInterceptor,
    Serializable {
        private DynamicUnadvisedExposedInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object object;
            Object oldProxy = null;
            Object target = Cglib2AopProxy.this.advised.getTargetSource().getTarget();
            try {
                oldProxy = AopContext.setCurrentProxy(proxy);
                Object ret = methodProxy.invoke(target, args);
                object = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, target, ret);
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                AopContext.setCurrentProxy(oldProxy);
                Cglib2AopProxy.this.advised.getTargetSource().releaseTarget(target);
                throw throwable;
            }
            AopContext.setCurrentProxy(oldProxy);
            Cglib2AopProxy.this.advised.getTargetSource().releaseTarget(target);
            return object;
        }
    }

    private class DynamicUnadvisedInterceptor
    implements MethodInterceptor,
    Serializable {
        private DynamicUnadvisedInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object target = Cglib2AopProxy.this.advised.getTargetSource().getTarget();
            try {
                Object ret = methodProxy.invoke(target, args);
                Object object = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, target, ret);
                return object;
            }
            finally {
                Cglib2AopProxy.this.advised.getTargetSource().releaseTarget(target);
            }
        }
    }

    private static class StaticUnadvisedExposedInterceptor
    implements MethodInterceptor,
    Serializable {
        private final Object target;

        public StaticUnadvisedExposedInterceptor(Object target) {
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object oldProxy = null;
            boolean setProxyContext = false;
            try {
                oldProxy = AopContext.setCurrentProxy(proxy);
                Object retVal = methodProxy.invoke(this.target, args);
                Object object = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, this.target, retVal);
                return object;
            }
            finally {
                AopContext.setCurrentProxy(oldProxy);
            }
        }
    }

    private static class StaticUnadvisedInterceptor
    implements MethodInterceptor,
    Serializable {
        private final Object target;

        public StaticUnadvisedInterceptor(Object target) {
            this.target = target;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object retVal = methodProxy.invoke(this.target, args);
            return Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, this.target, retVal);
        }
    }
}

