/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.ActivityInspectorManager;
import jp.co.argo21.nautica.tool.wfd.DesktopPane;
import jp.co.argo21.nautica.tool.wfd.InspectorManager;
import jp.co.argo21.nautica.tool.wfd.ProcessDesignFrame;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.inspector.Inspector;

public class ActivityInspectorView
extends JPanel {
    private InspectorManager manager = new ActivityInspectorManager();
    private JScrollPane scroll;
    private JButton setButton;
    private Inspector inspector;

    public ActivityInspectorView() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        this.scroll = new JScrollPane();
        this.scroll.setPreferredSize(new Dimension(500, 500));
        this.scroll.setMinimumSize(new Dimension(500, 500));
        this.scroll.setViewportView((JComponent)((Object)this.inspector));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2, 10, 10));
        this.setButton = new JButton(rm.getResource("JButton.label.set"));
        this.setButton.addActionListener(new SetInfoAction());
        buttonPane.add(this.setButton);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroll, "Center");
        this.add((Component)buttonPane, "South");
        this.inspect(null);
    }

    public void inspect(ActivityElement elem) {
        if (this.inspector != null) {
            this.inspector.unload();
        }
        if (elem == null) {
            this.inspector = this.manager.getDefaultInspector();
        } else {
            String inspectorName = elem.getType();
            this.inspector = this.manager.getInspectorForName(inspectorName);
        }
        this.inspector.init();
        this.inspector.setInspectable(elem);
        this.setButton.setEnabled(!this.inspector.isAutoCommit());
        this.scroll.setViewportView((JComponent)((Object)this.inspector));
        this.repaint();
    }

    class SetInfoAction
    implements ActionListener {
        SetInfoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            DesktopPane desktop;
            ProcessDesignFrame frame;
            if (ActivityInspectorView.this.inspector != null && ActivityInspectorView.this.inspector.check()) {
                ActivityInspectorView.this.inspector.commit();
            }
            if ((frame = (desktop = WorkflowDesignerManager.getMainFrame().getDesktop()).getCurrentProcessDesignFrame()) == null) {
                return;
            }
            frame.getView().repaint();
        }
    }
}

