/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.wfmc.x2002.xpdl10.PackageDocument;

public class FileManager {
    private static final String EMPTY_FLOW = "/jp/co/argo21/nautica/tool/wfd/resources/empty.xpdl";
    private static final String INITIAL_FLOW = "/jp/co/argo21/nautica/tool/wfd/resources/initial.xpdl";
    private String filename;
    private PackageDocument document;

    public String getFilename() {
        return this.filename;
    }

    public PackageDocument getDocument() {
        return this.document;
    }

    public void setDocument(PackageDocument doc) {
        this.document = doc;
    }

    public PackageDocument getEmptyDocument() throws XmlException, IOException {
        InputStream in = this.getClass().getResourceAsStream(EMPTY_FLOW);
        XmlOptions opts = new XmlOptions();
        opts.setCharacterEncoding("utf-8");
        PackageDocument doc = PackageDocument.Factory.parse((InputStream)in, (XmlOptions)opts);
        in.close();
        return doc;
    }

    public void initDocument() throws XmlException, IOException {
        this.filename = null;
        InputStream in = this.getClass().getResourceAsStream(INITIAL_FLOW);
        XmlOptions opts = new XmlOptions();
        opts.setCharacterEncoding("utf-8");
        this.document = PackageDocument.Factory.parse((InputStream)in, (XmlOptions)opts);
        in.close();
    }

    public void loadDocument(String fn) throws XmlException, IOException {
        File f = new File(fn);
        FileInputStream in = new FileInputStream(f);
        XmlOptions opts = new XmlOptions();
        opts.setCharacterEncoding("utf-8");
        this.document = PackageDocument.Factory.parse((InputStream)in, (XmlOptions)opts);
        ((InputStream)in).close();
        this.filename = fn;
    }

    public void saveDocument() throws XmlException, IOException {
        FileOutputStream out = new FileOutputStream(this.filename);
        XmlOptions opts = new XmlOptions();
        opts.setSavePrettyPrint();
        opts.setSavePrettyPrintIndent(2);
        opts.setCharacterEncoding("utf-8");
        this.document.save((OutputStream)out, opts);
        ((OutputStream)out).close();
    }

    public void saveDocument(String fn) throws XmlException, IOException {
        FileOutputStream out = new FileOutputStream(fn);
        XmlOptions opts = new XmlOptions();
        opts.setSavePrettyPrint();
        opts.setSavePrettyPrintIndent(2);
        opts.setCharacterEncoding("utf-8");
        this.document.save((OutputStream)out, opts);
        ((OutputStream)out).close();
        this.filename = fn;
    }
}

