/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.util.Hashtable;
import java.util.Map;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.inspector.Inspector;
import jp.co.argo21.nautica.tool.wfd.inspector.NoInspectableInspector;

public class InspectorManager {
    public static final String DEFALT_INSPECTOR = "DEFAULT_INSPECTOR";
    private Map inspectors = new Hashtable();

    public InspectorManager() {
        this.putInspectorForName(DEFALT_INSPECTOR, new NoInspectableInspector());
    }

    public Inspector getDefaultInspector() {
        return (Inspector)this.inspectors.get(DEFALT_INSPECTOR);
    }

    public Inspector getInspectorForName(String name) {
        if (name == null) {
            return this.getDefaultInspector();
        }
        Inspector inspector = (Inspector)this.inspectors.get(name);
        if (inspector == null) {
            return this.getDefaultInspector();
        }
        return inspector;
    }

    protected void putInspectorForName(String name, Inspector inspector) {
        if (StringUtils.checkNull(name)) {
            return;
        }
        if (inspector == null) {
            return;
        }
        this.inspectors.put(name, inspector);
    }
}

