/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class ResizingCorner
extends JComponent {
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 3;
    private static final Border L_BORDER = BorderFactory.createBevelBorder(1, Color.CYAN, Color.BLACK);
    private static final Border R_BORDER = BorderFactory.createBevelBorder(0, Color.CYAN, Color.BLACK);
    private List listeners = new ArrayList();
    private int orientation = 4;
    private boolean pushing;

    public ResizingCorner(int orientation) {
        this.orientation = orientation;
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ActionEvent event = new ActionEvent(e.getSource(), e.getID(), e.paramString());
                int count = ResizingCorner.this.listeners.size();
                for (int i = 0; i < count; ++i) {
                    ActionListener l = (ActionListener)ResizingCorner.this.listeners.get(i);
                    l.actionPerformed(event);
                }
            }

            public void mousePressed(MouseEvent e) {
                ResizingCorner.this.pushing = true;
                ResizingCorner.this.repaint();
            }

            public void mouseReleased(MouseEvent e) {
                ResizingCorner.this.pushing = false;
                ResizingCorner.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                ResizingCorner.this.pushing = false;
                ResizingCorner.this.repaint();
            }
        });
    }

    public void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(Color.BLUE);
        g.fillRect(0, 0, size.width, size.height);
        Border border = this.pushing ? L_BORDER : R_BORDER;
        border.paintBorder(this, g, 0, 0, size.width, size.height);
        Polygon polygon = null;
        int t = 3;
        int m = size.height / 2;
        int b = size.height - 4;
        int l = 3;
        int c = size.width / 2;
        int r = size.width - 4;
        if (this.orientation == 1) {
            int[] x = new int[]{l, c, r, l};
            int[] y = new int[]{b, t, b, b};
            polygon = new Polygon(x, y, 4);
        } else if (this.orientation == 2) {
            int[] x = new int[]{r, l, r, r};
            int[] y = new int[]{t, m, b, t};
            polygon = new Polygon(x, y, 4);
        } else if (this.orientation == 4) {
            int[] x = new int[]{l, r, l, l};
            int[] y = new int[]{t, m, b, t};
            polygon = new Polygon(x, y, 4);
        } else if (this.orientation == 3) {
            int[] x = new int[]{l, c, r, l};
            int[] y = new int[]{t, b, t, t};
            polygon = new Polygon(x, y, 4);
        }
        if (polygon != null) {
            g.setColor(Color.YELLOW);
            g.fillPolygon(polygon);
            g.setColor(Color.GREEN);
            g.drawPolygon(polygon);
        }
        g.dispose();
    }

    public void addActionListener(ActionListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeActionListener(ActionListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }
}

