/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.IconManager;
import jp.co.argo21.nautica.tool.wfd.ValidationResult;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.ApplicationElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;
import jp.co.argo21.nautica.tool.wfd.element.ParticipantElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;

public class ValidationResultView
extends JTabbedPane {
    private List results;
    private static String[] columnNames;
    private static int[] columnWidths;
    private static String[] resultKinds;
    protected static final Border border;
    private JTable resultTable;
    static /* synthetic */ Class class$jp$co$argo21$nautica$tool$wfd$element$Element;
    static /* synthetic */ Class class$java$lang$String;

    public ValidationResultView() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        JPanel panel1 = this.createResultPanel(rm);
        this.addTab(rm.getResource("ValidationResultView.tab.0"), panel1);
        this.validate();
    }

    private JPanel createResultPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(border);
        Dimension size = new Dimension(420, 250);
        panel.setSize(size);
        panel.setPreferredSize(size);
        this.resultTable = new JTable(new ResultTableModel());
        this.resultTable.setSelectionMode(0);
        this.resultTable.setAutoResizeMode(0);
        this.resultTable.setRowHeight(35);
        TableColumn column = null;
        for (int i = 0; i < columnWidths.length; ++i) {
            column = this.resultTable.getColumnModel().getColumn(i);
            if (i == 1) {
                column.setCellRenderer(new ElementRenderer());
            }
            column.setPreferredWidth(columnWidths[i]);
        }
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(this.resultTable);
        panel.add((Component)sp, 0);
        this.validate();
        return panel;
    }

    protected Component locate(Component component, int x, int y, int w, int h) {
        component.setLocation(x, y);
        component.setSize(w, h);
        return component;
    }

    public void setResults(List list) {
        this.results = list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        border = BorderFactory.createEtchedBorder();
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        columnNames = new String[3];
        ValidationResultView.columnNames[0] = rm.getResource("ValidationResultTableModel.columnName.0");
        ValidationResultView.columnNames[1] = rm.getResource("ValidationResultTableModel.columnName.1");
        ValidationResultView.columnNames[2] = rm.getResource("ValidationResultTableModel.columnName.2");
        columnWidths = new int[3];
        ValidationResultView.columnWidths[0] = 50;
        ValidationResultView.columnWidths[1] = 150;
        ValidationResultView.columnWidths[2] = 400;
        resultKinds = new String[2];
        ValidationResultView.resultKinds[0] = rm.getResource("ValidationResultTableModel.resultKind.0");
        ValidationResultView.resultKinds[1] = rm.getResource("ValidationResultTableModel.resultKind.1");
    }

    public class ElementRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
            Element elem = (Element)o;
            this.setText(this.getName(elem));
            Icon icon = this.getIcon(elem);
            if (icon != null) {
                this.setIcon(icon);
            }
            this.setToolTipText(this.getTooltipText(elem));
            return this;
        }

        private String getName(Element e) {
            Object name = null;
            if (e instanceof TransitionElement) {
                return ((TransitionElement)e).getSource().getName();
            }
            return e.getName();
        }

        private String getTooltipText(Element e) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            Object name = null;
            if (e instanceof TransitionElement) {
                return ((TransitionElement)e).getSource().getTooltipText(rm);
            }
            return e.getTooltipText(rm);
        }

        private Icon getIcon(Element e) {
            String name = null;
            if (e instanceof PackageElement) {
                name = "package-cur";
            } else if (e instanceof ParticipantElement) {
                name = "participant-cur";
            } else if (e instanceof ApplicationElement) {
                name = "application-cur";
            } else if (e instanceof VariableElement) {
                name = "variable-cur";
            } else if (e instanceof ProcessElement) {
                name = "process-cur";
            } else if (e instanceof ParameterElement) {
                name = "parameter-cur";
            } else if (e instanceof ActivityElement) {
                name = ((ActivityElement)e).getActivityState().getIconName() + "-cur";
            } else if (e instanceof TransitionElement) {
                name = ((TransitionElement)e).getSource().getActivityState().getIconName() + "-cur";
            }
            if (name != null) {
                return IconManager.getIcon(name);
            }
            return null;
        }
    }

    class ResultTableModel
    extends AbstractTableModel {
        ResultTableModel() {
        }

        public int getColumnCount() {
            return columnNames.length;
        }

        public int getRowCount() {
            if (ValidationResultView.this.results == null) {
                return 0;
            }
            return ValidationResultView.this.results.size();
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            if (ValidationResultView.this.results == null) {
                return "";
            }
            ValidationResult result = (ValidationResult)ValidationResultView.this.results.get(row);
            if (col == 0) {
                return resultKinds[result.getKind()];
            }
            if (col == 1) {
                return result.getElement();
            }
            if (col == 2) {
                return result.getMessage();
            }
            return "";
        }

        public Class getColumnClass(int col) {
            if (col == 1) {
                return class$jp$co$argo21$nautica$tool$wfd$element$Element == null ? (class$jp$co$argo21$nautica$tool$wfd$element$Element = ValidationResultView.class$("jp.co.argo21.nautica.tool.wfd.element.Element")) : class$jp$co$argo21$nautica$tool$wfd$element$Element;
            }
            return class$java$lang$String == null ? (class$java$lang$String = ValidationResultView.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

