/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.ElementFactory;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;
import jp.co.argo21.nautica.tool.wfd.inspector.AbstractElementInspector;

public class ParameterInspector
extends AbstractElementInspector {
    public static String[] PARAM_TYPES;
    public static String[] PARAM_MODES;
    protected static final Border border;
    private JLabel idField;
    private JComboBox typeBox;
    private JComboBox modeBox;
    private JTextField descriptionField;

    public ParameterInspector() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        JPanel panel = this.createBasicInfoPanel(rm);
        this.addTab(rm.getResource("ParameterInspector.tab.0"), panel);
        this.validate();
    }

    private JPanel createBasicInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(border);
        Dimension size = new Dimension(380, 200);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("ParameterInspector.label.0"));
        JLabel l1 = new JLabel(rm.getResource("ParameterInspector.label.1"));
        JLabel l2 = new JLabel(rm.getResource("ParameterInspector.label.2"));
        JLabel l3 = new JLabel(rm.getResource("ParameterInspector.label.3"));
        this.idField = new JLabel();
        this.idField.setBorder(border);
        this.descriptionField = new JTextField();
        this.descriptionField.setDocument(new ByteLimitedDocument(128));
        this.typeBox = new JComboBox<String>(PARAM_TYPES);
        this.modeBox = new JComboBox<String>(PARAM_MODES);
        panel.add(this.locate(l0, 10, 10, 100, 25));
        panel.add(this.locate(l1, 10, 40, 100, 25));
        panel.add(this.locate(l2, 10, 70, 100, 25));
        panel.add(this.locate(l3, 10, 100, 100, 25));
        panel.add(this.locate(this.idField, 110, 10, 190, 25));
        panel.add(this.locate(this.typeBox, 110, 40, 190, 25));
        panel.add(this.locate(this.modeBox, 110, 70, 190, 25));
        panel.add(this.locate(this.descriptionField, 110, 100, 190, 25));
        this.validate();
        return panel;
    }

    public void init() {
        super.init();
        this.idField.setText("");
        this.descriptionField.setText("");
        this.typeBox.setSelectedIndex(0);
        this.modeBox.setSelectedIndex(0);
    }

    public void setInspectable(Element elem) {
        super.setInspectable(elem);
        if (elem != null && elem instanceof ParameterElement) {
            ParameterElement param = (ParameterElement)elem;
            this.idField.setText(param.getID());
            int t = param.getType();
            if (t == 1) {
                this.typeBox.setSelectedIndex(0);
            } else if (t == 3) {
                this.typeBox.setSelectedIndex(1);
            } else if (t == 6) {
                this.typeBox.setSelectedIndex(2);
            } else {
                this.typeBox.setSelectedIndex(0);
            }
            int m = param.getMode();
            if (m == 1) {
                this.modeBox.setSelectedIndex(0);
            } else if (m == 2) {
                this.modeBox.setSelectedIndex(1);
            } else if (m == 3) {
                this.modeBox.setSelectedIndex(2);
            } else {
                this.modeBox.setSelectedIndex(2);
            }
            this.descriptionField.setText(param.getDescription());
        }
        this.setSelectedIndex(0);
        this.repaint();
    }

    public boolean check() {
        return true;
    }

    public void commit() {
        if (this.getInspectable() == null) {
            super.setInspectable(ElementFactory.getInstance().createElement("parameter"));
        }
        if (this.getInspectable() instanceof ParameterElement) {
            ParameterElement param = (ParameterElement)this.getInspectable();
            int t = this.typeBox.getSelectedIndex();
            if (t == 0) {
                param.setType(1);
            } else if (t == 1) {
                param.setType(3);
            } else if (t == 2) {
                param.setType(6);
            }
            int m = this.modeBox.getSelectedIndex();
            if (m == 0) {
                param.setMode(1);
            } else if (m == 1) {
                param.setMode(2);
            } else if (m == 2) {
                param.setMode(3);
            }
            param.setDescription(this.descriptionField.getText());
            this.fireElementChanged();
        }
    }

    protected Component locate(Component component, int x, int y, int w, int h) {
        component.setLocation(x, y);
        component.setSize(w, h);
        return component;
    }

    static {
        border = BorderFactory.createEtchedBorder();
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        PARAM_TYPES = new String[3];
        ParameterInspector.PARAM_TYPES[0] = rm.getResource("ParameterInspector.type.0");
        ParameterInspector.PARAM_TYPES[1] = rm.getResource("ParameterInspector.type.1");
        ParameterInspector.PARAM_TYPES[2] = rm.getResource("ParameterInspector.type.2");
        PARAM_MODES = new String[3];
        ParameterInspector.PARAM_MODES[0] = rm.getResource("ParameterInspector.mode.0");
        ParameterInspector.PARAM_MODES[1] = rm.getResource("ParameterInspector.mode.1");
        ParameterInspector.PARAM_MODES[2] = rm.getResource("ParameterInspector.mode.2");
    }
}

