/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.IconView;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.ParticipantElement;
import jp.co.argo21.nautica.tool.wfd.inspector.AbstractElementInspector;

public class ParticipantInspector
extends AbstractElementInspector {
    private static String[] types;
    protected static final Border border;
    private IconView iconView;
    private JLabel idField;
    private JTextField nameField;
    private JComboBox typeBox;
    private JTextField descriptionField;

    public ParticipantInspector() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        JPanel panel = this.createBasicInfoPanel(rm);
        this.addTab(rm.getResource("ParticipantInspector.tab.0"), panel);
        this.validate();
    }

    private JPanel createBasicInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(border);
        Dimension size = new Dimension(380, 200);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("ParticipantInspector.label.0"));
        JLabel l1 = new JLabel(rm.getResource("ParticipantInspector.label.1"));
        JLabel l2 = new JLabel(rm.getResource("ParticipantInspector.label.2"));
        JLabel l3 = new JLabel(rm.getResource("ParticipantInspector.label.3"));
        this.iconView = new IconView();
        this.iconView.setIconName("participant");
        this.idField = new JLabel();
        this.idField.setBorder(border);
        this.nameField = new JTextField();
        this.nameField.setDocument(new ByteLimitedDocument(64));
        this.descriptionField = new JTextField();
        this.descriptionField.setDocument(new ByteLimitedDocument(128));
        this.typeBox = new JComboBox<String>(types);
        panel.add(this.locate(this.iconView, 10, 10, 60, 60));
        panel.add(this.locate(l0, 80, 10, 100, 25));
        panel.add(this.locate(l1, 80, 40, 100, 25));
        panel.add(this.locate(l2, 80, 70, 100, 25));
        panel.add(this.locate(l3, 80, 100, 100, 25));
        panel.add(this.locate(this.idField, 180, 10, 190, 25));
        panel.add(this.locate(this.nameField, 180, 40, 190, 25));
        panel.add(this.locate(this.typeBox, 180, 70, 190, 25));
        panel.add(this.locate(this.descriptionField, 180, 100, 190, 25));
        this.validate();
        return panel;
    }

    public void init() {
        super.init();
        this.nameField.setText("");
        this.descriptionField.setText("");
        this.typeBox.setSelectedIndex(0);
    }

    public void setInspectable(Element elem) {
        super.setInspectable(elem);
        if (elem != null && elem instanceof ParticipantElement) {
            ParticipantElement part = (ParticipantElement)elem;
            this.idField.setText(part.getID());
            this.nameField.setText(part.getName());
            int t = part.getType();
            if (t == 3) {
                this.typeBox.setSelectedIndex(0);
            } else if (t == 4) {
                this.typeBox.setSelectedIndex(1);
            } else if (t == 5) {
                this.typeBox.setSelectedIndex(2);
            } else if (t == 6) {
                this.typeBox.setSelectedIndex(3);
            } else {
                this.typeBox.setSelectedIndex(3);
            }
            this.descriptionField.setText(part.getDescription());
        }
        this.setSelectedIndex(0);
    }

    public boolean check() {
        return true;
    }

    public void commit() {
        Element e = this.getInspectable();
        if (e != null && e instanceof ParticipantElement) {
            ParticipantElement part = (ParticipantElement)e;
            part.setName(this.nameField.getText());
            int t = this.typeBox.getSelectedIndex();
            if (t == 0) {
                part.setType(3);
            } else if (t == 1) {
                part.setType(4);
            } else if (t == 2) {
                part.setType(5);
            } else if (t == 3) {
                part.setType(6);
            }
            part.setDescription(this.descriptionField.getText());
            this.fireElementChanged();
        }
    }

    protected Component locate(Component component, int x, int y, int w, int h) {
        component.setLocation(x, y);
        component.setSize(w, h);
        return component;
    }

    static {
        border = BorderFactory.createEtchedBorder();
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        types = new String[4];
        ParticipantInspector.types[0] = rm.getResource("ParticipantInspector.type.0");
        ParticipantInspector.types[1] = rm.getResource("ParticipantInspector.type.1");
        ParticipantInspector.types[2] = rm.getResource("ParticipantInspector.type.2");
        ParticipantInspector.types[3] = rm.getResource("ParticipantInspector.type.3");
    }
}

