/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.print;

import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.print.PrintData;

public final class PrintManager {
    private static PrintManager singleton = null;
    private PrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();

    private PrintManager() {
        this.aset.add(OrientationRequested.PORTRAIT);
        this.aset.add(MediaSizeName.ISO_A4);
        this.aset.add(new Copies(1));
        this.aset.add(new JobName("WorkflowDesigner", null));
    }

    public static PrintManager getInstance() {
        if (singleton == null) {
            singleton = new PrintManager();
        }
        return singleton;
    }

    public static void releaseInstance() {
        singleton = null;
    }

    public PrintRequestAttributeSet getCurrentPageFormat() {
        return this.aset;
    }

    public void print(PrintData data) {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        if (data == null) {
            DialogUtilities.showError(rm.getResource("message.error.0001"));
            return;
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable(data);
        PrintService[] services = PrinterJob.lookupPrintServices();
        if (services.length > 0) {
            try {
                job.setPrintService(services[0]);
                PageFormat format = job.pageDialog(this.aset);
                if (format == null) {
                    return;
                }
                data.setFormat(format);
                if (job.printDialog(this.aset)) {
                    job.print(this.aset);
                }
            }
            catch (PrinterException ex) {
                DialogUtilities.showError(rm.getResource("message.error.0002"));
            }
        } else {
            DialogUtilities.showError(rm.getResource("message.error.0003"));
        }
    }
}

