/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm;

import java.awt.Frame;
import javax.swing.ActionMap;
import jp.co.argo21.commons.swing.ExceptionViewer;
import jp.co.argo21.commons.swing.HelpViewer;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.VersionWindow;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminFrame;
import jp.co.argo21.nautica.tool.wfadm.action.ExceptionViewerAction;
import jp.co.argo21.nautica.tool.wfadm.action.ExitAction;
import jp.co.argo21.nautica.tool.wfadm.action.HelpAction;
import jp.co.argo21.nautica.tool.wfadm.action.OpenAction;
import jp.co.argo21.nautica.tool.wfadm.action.PreferencesAction;
import jp.co.argo21.nautica.tool.wfadm.action.RegisterDefinitionAction;
import jp.co.argo21.nautica.tool.wfadm.action.ShutdownAction;
import jp.co.argo21.nautica.tool.wfadm.action.VersionAction;
import jp.co.argo21.nautica.tool.wfadm.common.BusyDialog;
import jp.co.argo21.nautica.tool.wfadm.common.BusyTask;
import jp.co.argo21.nautica.tool.wfadm.pref.PreferenceManager;

public class WorkflowAdminManager {
    private static final String BUNDLE_PATH = "jp.co.argo21.nautica.tool.wfadm.resources.messages";
    private static ResourceManager resourceManager;
    private static WorkflowAdminFrame mainFrame;
    private static ExceptionViewer exceptionViewer;
    private static VersionWindow versionWindow;
    private static HelpViewer helpViewer;
    private static ActionMap actionMap;
    private static BusyDialog busyDialog;

    public static void boot() throws Exception {
        resourceManager = new ResourceManager(BUNDLE_PATH);
        versionWindow = new VersionWindow();
        versionWindow.setVisible(true);
        PreferenceManager.create();
        WorkflowAdminManager.createActionMap();
        long t = System.currentTimeMillis() + 1500L;
        while (System.currentTimeMillis() < t) {
        }
        mainFrame = new WorkflowAdminFrame();
        exceptionViewer = new ExceptionViewer((Frame)mainFrame, false);
        helpViewer = new HelpViewer();
        busyDialog = new BusyDialog(mainFrame);
        mainFrame.setVisible(true);
        versionWindow.setVisible(false);
    }

    public static ResourceManager getResourceManager() {
        return resourceManager;
    }

    public static void setException(Exception ex) {
        exceptionViewer.setThrowable(ex);
    }

    public static ExceptionViewer getExceptionViewer() {
        return exceptionViewer;
    }

    public static HelpViewer getHelpViewer() {
        return helpViewer;
    }

    public static WorkflowAdminFrame getMainFrame() {
        return mainFrame;
    }

    public static VersionWindow getVersionWindow() {
        return versionWindow;
    }

    public static void runBusyTask(BusyTask task) {
        if (task == null) {
            return;
        }
        busyDialog.setTask(task);
    }

    public static ActionMap getActionMap() {
        return actionMap;
    }

    private static void createActionMap() {
        actionMap = new ActionMap();
        actionMap.put("registerDefinition", new RegisterDefinitionAction());
        actionMap.put("openEngine", new OpenAction());
        actionMap.put("shutdownEngine", new ShutdownAction());
        actionMap.put("exit", new ExitAction());
        actionMap.put("exceptionViewer", new ExceptionViewerAction());
        actionMap.put("preferences", new PreferencesAction());
        actionMap.put("help", new HelpAction());
        actionMap.put("about", new VersionAction());
    }
}

