/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.BusyTask;

public class BusyDialog
extends JDialog {
    private Timer timer;
    private BusyTask task;

    public BusyDialog(Frame frame) {
        super(frame, true);
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        JOptionPane optionPane = new JOptionPane();
        JLabel waitLabel = new JLabel(rm.getResource("BusyDialog.waitingMessage"));
        waitLabel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        waitLabel.setOpaque(false);
        waitLabel.setForeground(Color.white);
        Container c = this.getContentPane();
        c.add((Component)waitLabel, "Center");
        c.setBackground(new Color(51, 51, 170));
        this.setTitle(rm.getResource("BusyDialog.title"));
        this.pack();
        this.setResizable(false);
        this.timer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (BusyDialog.this.task == null) {
                    return;
                }
                int state = BusyDialog.this.task.getState();
                if (state == 0) {
                    try {
                        BusyDialog.this.task.run();
                    }
                    catch (Exception ex) {
                        BusyDialog.this.hideDialog();
                    }
                } else if (state == 2) {
                    BusyDialog.this.hideDialog();
                }
            }
        });
    }

    public void setTask(BusyTask task) {
        if (task == null) {
            return;
        }
        this.task = task;
        this.showDialog();
    }

    private void showDialog() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int sw = screen.width;
        int sh = screen.height;
        Dimension size = this.getSize();
        this.setLocation((sw - size.width) / 2, (sh - size.height) / 2);
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer.restart();
        this.setVisible(true);
    }

    private void hideDialog() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.setVisible(false);
    }
}

