/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.DialogComponent;
import jp.co.argo21.nautica.tool.wfadm.pref.EngineInfo;
import jp.co.argo21.nautica.tool.wfadm.pref.PreferenceManager;

public class OpenEngineComponent
extends DialogComponent {
    private static String[] columnNames;
    protected static final Border border;
    private JTable engineInfoTable;
    private EngineInfo selectedEngineInfo;
    static /* synthetic */ Class class$java$lang$String;

    public OpenEngineComponent() {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        JPanel panel = this.createEngineInfoPanel(rm);
        this.addTab(rm.getResource("OpenEngineComponent.tab.0"), panel);
        this.validate();
    }

    private JPanel createEngineInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(border);
        Dimension size = new Dimension(500, 150);
        panel.setSize(size);
        panel.setPreferredSize(size);
        this.engineInfoTable = new JTable(new EngineInfoTableModel());
        this.engineInfoTable.setSelectionMode(0);
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(this.engineInfoTable);
        panel.add((Component)sp, "Center");
        this.validate();
        return panel;
    }

    public void init() {
        this.selectedEngineInfo = null;
    }

    public boolean commit() {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        int selected = this.engineInfoTable.getSelectedRow();
        if (selected < 0) {
            DialogUtilities.showWarning(rm.getResource("W9001"));
            return false;
        }
        PreferenceManager pm = PreferenceManager.getInstance();
        this.selectedEngineInfo = pm.getEngineInfo(selected);
        return true;
    }

    public EngineInfo getSelectedEngineInfo() {
        return this.selectedEngineInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        border = BorderFactory.createEtchedBorder();
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        columnNames = new String[4];
        OpenEngineComponent.columnNames[0] = rm.getResource("OpenEngineComponent.columnName.0");
        OpenEngineComponent.columnNames[1] = rm.getResource("OpenEngineComponent.columnName.1");
        OpenEngineComponent.columnNames[2] = rm.getResource("OpenEngineComponent.columnName.2");
        OpenEngineComponent.columnNames[3] = rm.getResource("OpenEngineComponent.columnName.3");
    }

    class EngineInfoTableModel
    extends AbstractTableModel {
        EngineInfoTableModel() {
        }

        public int getColumnCount() {
            return columnNames.length;
        }

        public int getRowCount() {
            PreferenceManager pm = PreferenceManager.getInstance();
            return pm.getEngineInfoCount();
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            PreferenceManager pm = PreferenceManager.getInstance();
            EngineInfo info = pm.getEngineInfo(row);
            if (info == null) {
                return "";
            }
            if (col == 0) {
                return info.getName();
            }
            if (col == 1) {
                return info.getURL();
            }
            if (col == 2) {
                return info.getScope();
            }
            if (col == 3) {
                return info.getUser();
            }
            return "";
        }

        public Class getColumnClass(int col) {
            return class$java$lang$String == null ? (class$java$lang$String = OpenEngineComponent.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

