/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.co.argo21.commons.swing.ExceptionViewer;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.definition.loader.DefinitionLoader;
import jp.co.argo21.nautica.tool.wfadm.pref.EngineInfo;
import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessor;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.rmi.DefinitionRepositoryRemote;
import jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote;
import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.ProcDef;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;

public class EngineViewController {
    private EngineInfo engineInfo;
    private Map pathMap = new Hashtable();
    private Map definitionMap = new Hashtable();

    public EngineViewController(EngineInfo info) {
        this.engineInfo = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkEngineConnection() {
        boolean bl;
        WorkflowServiceAccessor wsa = this.engineInfo.getWorkflowServiceAccessor();
        String session = null;
        try {
            try {
                session = wsa.open();
                bl = true;
                Object var7_5 = null;
                if (session == null) return bl;
            }
            catch (Exception ex) {
                ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                ev.setThrowable(ex);
                boolean bl2 = false;
                Object var7_6 = null;
                if (session == null) return bl2;
                try {
                    wsa.close();
                    return bl2;
                }
                catch (Exception ex2) {
                    ExceptionViewer ev2 = WorkflowAdminManager.getExceptionViewer();
                    ev2.setThrowable(ex2);
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (session == null) throw throwable;
            try {}
            catch (Exception ex2) {
                ExceptionViewer ev2 = WorkflowAdminManager.getExceptionViewer();
                ev2.setThrowable(ex2);
                throw throwable;
            }
            wsa.close();
            throw throwable;
        }
        try {}
        catch (Exception ex2) {
            ExceptionViewer ev2 = WorkflowAdminManager.getExceptionViewer();
            ev2.setThrowable(ex2);
            return bl;
        }
        wsa.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ProcDef[] getProcessDefinition(Filter filter) throws Exception {
        ProcDef[] procDefArray;
        WorkflowServiceAccessor wsa = this.engineInfo.getWorkflowServiceAccessor();
        String session = null;
        try {
            ProcDef[] defs;
            session = wsa.open();
            DefinitionRepositoryRemote dr = wsa.getDefinitionRepository();
            procDefArray = defs = dr.getProcessDefinitions(session, filter);
            Object var8_8 = null;
            if (session == null) return procDefArray;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (session == null) throw throwable;
            try {
                wsa.close();
                throw throwable;
            }
            catch (Exception ex2) {
                ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                ev.setThrowable(ex2);
                throw throwable;
            }
        }
        try {}
        catch (Exception ex2) {
            ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
            ev.setThrowable(ex2);
            return procDefArray;
        }
        wsa.close();
        return procDefArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Process[] getProcess(Filter filter) throws Exception {
        Process[] processArray;
        WorkflowServiceAccessor wsa = this.engineInfo.getWorkflowServiceAccessor();
        String session = null;
        try {
            Process[] procs;
            session = wsa.open();
            WorkflowEngineHandlerRemote weh = wsa.getWorkflowEngineHandler();
            processArray = procs = weh.getProcesses(session, filter);
            Object var8_8 = null;
            if (session == null) return processArray;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (session == null) throw throwable;
            try {
                wsa.close();
                throw throwable;
            }
            catch (Exception ex2) {
                ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                ev.setThrowable(ex2);
                throw throwable;
            }
        }
        try {}
        catch (Exception ex2) {
            ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
            ev.setThrowable(ex2);
            return processArray;
        }
        wsa.close();
        return processArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Process getProcess(String pid) throws Exception {
        Process process;
        WorkflowServiceAccessor wsa = this.engineInfo.getWorkflowServiceAccessor();
        String session = null;
        try {
            Process proc;
            session = wsa.open();
            WorkflowEngineHandlerRemote weh = wsa.getWorkflowEngineHandler();
            process = proc = weh.getProcess(session, pid);
            Object var8_8 = null;
            if (session == null) return process;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (session == null) throw throwable;
            try {
                wsa.close();
                throw throwable;
            }
            catch (Exception ex2) {
                ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                ev.setThrowable(ex2);
                throw throwable;
            }
        }
        try {}
        catch (Exception ex2) {
            ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
            ev.setThrowable(ex2);
            return process;
        }
        wsa.close();
        return process;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Activity[] getActivities(Process proc, Filter filter) throws Exception {
        Activity[] activityArray;
        WorkflowServiceAccessor wsa = this.engineInfo.getWorkflowServiceAccessor();
        String session = null;
        try {
            Activity[] acts;
            String pid = proc.getID();
            session = wsa.open();
            WorkflowEngineHandlerRemote weh = wsa.getWorkflowEngineHandler();
            activityArray = acts = weh.getActivities(session, pid, filter);
            Object var10_10 = null;
            if (session == null) return activityArray;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (session == null) throw throwable;
            try {
                wsa.close();
                throw throwable;
            }
            catch (Exception ex2) {
                ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                ev.setThrowable(ex2);
                throw throwable;
            }
        }
        try {}
        catch (Exception ex2) {
            ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
            ev.setThrowable(ex2);
            return activityArray;
        }
        wsa.close();
        return activityArray;
    }

    EngineInfo getEngineInfo() {
        return this.engineInfo;
    }

    PackageDefinition getPackgeDefinition(String pdname) throws Exception {
        String ename = this.engineInfo.getName();
        String path = this.getDefinitionPath(ename, pdname);
        PackageDefinition def = this.getDefinition(ename, path);
        return def;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void changeProcessState(String pid, ProcessState state) throws Exception {
        WorkflowServiceAccessor wsa = this.engineInfo.getWorkflowServiceAccessor();
        String session = null;
        session = wsa.open();
        WorkflowEngineHandlerRemote weh = wsa.getWorkflowEngineHandler();
        weh.changeProcessState(session, pid, state);
        Object var7_7 = null;
        if (session == null) return;
        try {
            wsa.close();
            return;
        }
        catch (Exception ex) {
            ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
            ev.setThrowable(ex);
        }
        return;
        {
            catch (Exception ex) {
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (session == null) throw throwable;
            try {
                wsa.close();
                throw throwable;
            }
            catch (Exception ex) {
                ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                ev.setThrowable(ex);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void changeActivityState(String pid, String aid, ActivityState state) throws Exception {
        WorkflowServiceAccessor wsa = this.engineInfo.getWorkflowServiceAccessor();
        String session = null;
        session = wsa.open();
        WorkflowEngineHandlerRemote weh = wsa.getWorkflowEngineHandler();
        weh.changeActivityState(session, pid, aid, state);
        Object var8_8 = null;
        if (session == null) return;
        try {
            wsa.close();
            return;
        }
        catch (Exception ex) {
            ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
            ev.setThrowable(ex);
        }
        return;
        {
            catch (Exception ex) {
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (session == null) throw throwable;
            try {
                wsa.close();
                throw throwable;
            }
            catch (Exception ex) {
                ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                ev.setThrowable(ex);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List getProcessAttributes(String pid, Filter filter) throws Exception {
        List<Attribute> list;
        WorkflowServiceAccessor wsa = this.engineInfo.getWorkflowServiceAccessor();
        String session = null;
        try {
            session = wsa.open();
            WorkflowEngineHandlerRemote weh = wsa.getWorkflowEngineHandler();
            Attribute[] attrs = weh.getProcessAttributes(session, pid, filter);
            list = Arrays.asList(attrs);
            Object var9_9 = null;
            if (session == null) return list;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (session == null) throw throwable;
            try {
                wsa.close();
                throw throwable;
            }
            catch (Exception ex2) {
                ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                ev.setThrowable(ex2);
                throw throwable;
            }
        }
        try {}
        catch (Exception ex2) {
            ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
            ev.setThrowable(ex2);
            return list;
        }
        wsa.close();
        return list;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setProcessAttributes(String pid, List attrs) throws Exception {
        WorkflowServiceAccessor wsa = this.engineInfo.getWorkflowServiceAccessor();
        String session = null;
        if (attrs == null) {
            return;
        }
        session = wsa.open();
        WorkflowEngineHandlerRemote weh = wsa.getWorkflowEngineHandler();
        Iterator it = attrs.iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            weh.assignProcessAttribute(session, pid, attr);
        }
        Object var9_9 = null;
        if (session == null) return;
        try {
            wsa.close();
            return;
        }
        catch (Exception ex) {
            ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
            ev.setThrowable(ex);
        }
        return;
        {
            catch (Exception ex) {
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (session == null) throw throwable;
            try {
                wsa.close();
                throw throwable;
            }
            catch (Exception ex) {
                ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                ev.setThrowable(ex);
            }
            throw throwable;
        }
    }

    private String getDefinitionPath(String ename, String pdname) throws Exception {
        String path = (String)this.pathMap.get(pdname);
        if (path == null) {
            DefinitionLoader loader = DefinitionLoader.getInstance();
            path = loader.getDefinitionPath(ename, pdname);
        }
        return path;
    }

    private PackageDefinition getDefinition(String ename, String path) throws Exception {
        PackageDefinition def = (PackageDefinition)this.definitionMap.get(path);
        if (def == null) {
            DefinitionLoader loader = DefinitionLoader.getInstance();
            def = loader.getDefinition(ename, path);
        }
        return def;
    }
}

