/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.pref;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.nautica.tool.wfadm.pref.AdminPreferencesDocument;
import jp.co.argo21.nautica.tool.wfadm.pref.EngineInfo;
import jp.co.argo21.nautica.tool.wfadm.pref.EngineInformationDocument;
import jp.co.argo21.nautica.tool.wfadm.pref.EngineInformationsDocument;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class PreferenceManager {
    public static final String SEP = System.getProperty("file.separator");
    private static final String PREF_FILE = SEP + "preferences.xml";
    private static PreferenceManager singleton;
    private String appDataPath;
    private String prefPath;
    private ArrayList engineInfos = new ArrayList();

    public static void create() throws Exception {
        singleton = new PreferenceManager();
        singleton.init();
    }

    public static PreferenceManager getInstance() {
        return singleton;
    }

    private PreferenceManager() {
    }

    private void init() throws Exception {
        this.initPath();
        this.loadPreferences();
    }

    public String getApplicationDataPath() {
        return this.appDataPath;
    }

    public List getAllEngineInfo() {
        return this.engineInfos;
    }

    public EngineInfo getEngineInfo(String engineName) {
        if (engineName == null || engineName.trim().equals("")) {
            return null;
        }
        Iterator it = this.engineInfos.iterator();
        while (it.hasNext()) {
            EngineInfo info = (EngineInfo)it.next();
            String name = info.getName();
            if (!name.equals(engineName)) continue;
            return info;
        }
        return null;
    }

    public EngineInfo getEngineInfo(int index) {
        if (index < 0 || index >= this.engineInfos.size()) {
            return null;
        }
        EngineInfo info = (EngineInfo)this.engineInfos.get(index);
        return info;
    }

    public boolean addEngineInfo(EngineInfo info) {
        if (info == null) {
            return false;
        }
        String name = info.getName();
        EngineInfo ei = this.getEngineInfo(name);
        if (ei != null) {
            return false;
        }
        this.engineInfos.add(info);
        return true;
    }

    public boolean updateEngineInfo(EngineInfo info) {
        if (info == null) {
            return false;
        }
        String name = info.getName();
        EngineInfo ei = this.getEngineInfo(name);
        if (ei == null) {
            return false;
        }
        int ix = this.engineInfos.indexOf(ei);
        this.engineInfos.set(ix, info);
        return true;
    }

    public boolean updateEngineInfo(int index, EngineInfo info) {
        if (index < 0 || index >= this.engineInfos.size()) {
            return false;
        }
        if (info == null) {
            return false;
        }
        String name = info.getName();
        EngineInfo ei1 = this.getEngineInfo(name);
        EngineInfo ei2 = this.getEngineInfo(index);
        if (ei1 != null && ei1 != ei2) {
            return false;
        }
        this.engineInfos.set(index, info);
        return true;
    }

    public boolean removeEngineInfo(String engineName) {
        EngineInfo ei = this.getEngineInfo(engineName);
        if (ei == null) {
            return false;
        }
        int ix = this.engineInfos.indexOf(ei);
        this.engineInfos.remove(ix);
        return true;
    }

    public boolean removeEngineInfo(int index) {
        if (index < 0 || index >= this.engineInfos.size()) {
            return false;
        }
        this.engineInfos.remove(index);
        return true;
    }

    public int getEngineInfoCount() {
        return this.engineInfos.size();
    }

    public void load() throws IOException, XmlException {
        this.loadPreferences();
    }

    public void save() throws IOException, XmlException {
        this.savePreferences();
    }

    private void loadPreferences() throws IOException, XmlException {
        this.engineInfos.clear();
        File f = new File(this.prefPath);
        if (f.exists()) {
            FileInputStream in = new FileInputStream(f);
            XmlOptions opts = new XmlOptions();
            opts.setCharacterEncoding("utf-8");
            AdminPreferencesDocument doc = AdminPreferencesDocument.Factory.parse((InputStream)in, (XmlOptions)opts);
            ((InputStream)in).close();
            AdminPreferencesDocument.AdminPreferences prefs = doc.getAdminPreferences();
            if (prefs != null) {
                EngineInformationsDocument.EngineInformations einfos = prefs.getEngineInformations();
                this.loadEngineInformations(einfos);
            }
        }
    }

    private void loadEngineInformations(EngineInformationsDocument.EngineInformations einfos) {
        if (einfos == null) {
            return;
        }
        EngineInformationDocument.EngineInformation[] einfo = einfos.getEngineInformationArray();
        if (einfo == null) {
            return;
        }
        for (int i = 0; i < einfo.length; ++i) {
            this.loadEngineInformation(einfo[i]);
        }
    }

    private void loadEngineInformation(EngineInformationDocument.EngineInformation einfo) {
        if (einfo == null) {
            return;
        }
        String name = einfo.getName();
        EngineInfo info = new EngineInfo(einfo);
        this.engineInfos.add(info);
    }

    private void savePreferences() throws IOException, XmlException {
        EngineInformationsDocument.EngineInformations einfos;
        AdminPreferencesDocument doc = AdminPreferencesDocument.Factory.newInstance();
        AdminPreferencesDocument.AdminPreferences prefs = doc.getAdminPreferences();
        if (prefs == null) {
            prefs = doc.addNewAdminPreferences();
        }
        if ((einfos = prefs.getEngineInformations()) == null) {
            einfos = prefs.addNewEngineInformations();
            this.saveEngineInformations(einfos);
        }
        FileOutputStream out = new FileOutputStream(this.prefPath);
        XmlOptions opts = new XmlOptions();
        opts.setSavePrettyPrint();
        opts.setSavePrettyPrintIndent(2);
        opts.setCharacterEncoding("utf-8");
        doc.save((OutputStream)out, opts);
        ((OutputStream)out).close();
    }

    private void saveEngineInformations(EngineInformationsDocument.EngineInformations einfos) {
        Iterator it = this.engineInfos.iterator();
        while (it.hasNext()) {
            EngineInfo info = (EngineInfo)it.next();
            if (info == null) continue;
            EngineInformationDocument.EngineInformation einfo = einfos.addNewEngineInformation();
            einfo.setName(info.getName());
            einfo.setUrl(info.getURL());
            einfo.setScope(info.getScope());
            einfo.setUser(info.getUser());
            einfo.setPassword(info.getPassword());
            einfo.setAdminKey(info.getAdminKey());
        }
    }

    private void initPath() {
        boolean created;
        String path = System.getProperty("user.home", ".");
        String osname = System.getProperty("os.name");
        path = osname.indexOf("Windows") >= 0 ? path + SEP + "Application Data" + SEP + "Nautica" + SEP + "WorkflowAdmin" : path + SEP + ".nautica" + SEP + "WorkflowAdmin";
        File dir = new File(path);
        if (!dir.exists() && !(created = dir.mkdirs())) {
            path = ".";
        }
        this.appDataPath = path;
        this.prefPath = path + PREF_FILE;
    }
}

