/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Timestamp;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ConcurrencyBlockDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.engine.AbstractActivityBehavior;
import jp.co.argo21.nautica.workflow.engine.ActivityInternal;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.EndActivityRequestMessage;
import jp.co.argo21.nautica.workflow.engine.EndProcessRequestMessage;
import jp.co.argo21.nautica.workflow.engine.ProcessInternal;
import jp.co.argo21.nautica.workflow.engine.SystemMessageTransporter;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;

public class EndActivityBehavior
extends AbstractActivityBehavior {
    public void abort(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act, boolean checkChild) throws Exception {
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        Timestamp ts = DataAccessManager.getAccessTime();
        actDAO.updateState(act.getBean(), ActivityState.CLOSED_ABORTED, ts);
    }

    public void complete(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act) throws Exception {
        ActivityBean abean = act.getBean();
        String pid = abean.getProcessID();
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        Timestamp ts = DataAccessManager.getAccessTime();
        actDAO.updateState(act.getBean(), ActivityState.CLOSED_COMPLETED, ts);
        WorkflowEngine engine = WorkflowEngine.getInstance();
        EndProcessRequestMessage eprmsg = new EndProcessRequestMessage(pid);
        SystemMessageTransporter mt = new SystemMessageTransporter("END_PROCESS_REQUEST");
        mt.sendMessage(eprmsg);
    }

    public void start(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act) throws Exception {
        ProcessBean pbean = proc.getBean();
        ActivityBean abean = act.getBean();
        String pid = abean.getProcessID();
        String aid = abean.getActivityID();
        String bid = abean.getBlockID();
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        Timestamp ts = DataAccessManager.getAccessTime();
        actDAO.updateState(act.getBean(), ActivityState.OPEN_RUNNING, ts);
        ConcurrencyBlockDAO cbDAO = daoFactory.getConcurrencyBlockDAO();
        int actcount = actDAO.findOpeningActivityCountByProcessID(pid);
        int sbcount = cbDAO.findSubblockExistenceByProcessID(pid);
        if (actcount == 1 && sbcount == 0) {
            WorkflowEngine engine = WorkflowEngine.getInstance();
            EndActivityRequestMessage earmsg = new EndActivityRequestMessage(pid, aid);
            SystemMessageTransporter mt = new SystemMessageTransporter("END_ACTIVITY_REQUEST");
            mt.sendMessage(earmsg);
        }
    }

    public void terminate(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act, boolean checkChild) throws Exception {
        ActivityBean abean = act.getBean();
        String pid = abean.getProcessID();
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        Timestamp ts = DataAccessManager.getAccessTime();
        actDAO.updateState(act.getBean(), ActivityState.CLOSED_TERMINATED, ts);
        WorkflowEngine engine = WorkflowEngine.getInstance();
        EndProcessRequestMessage eprmsg = new EndProcessRequestMessage(pid, ActivityState.CLOSED_TERMINATED);
        SystemMessageTransporter mt = new SystemMessageTransporter("END_PROCESS_REQUEST");
        mt.sendMessage(eprmsg);
    }
}

