/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import jp.co.argo21.nautica.workflow.engine.EngineConfigDocument;
import jp.co.argo21.nautica.workflow.engine.EngineDocument;
import jp.co.argo21.nautica.workflow.engine.RemoteEnginesDocument;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

class InterWorkflowConfig {
    private static final String CONFIG = "interworkflow.xml";
    private String engineID;
    private String enginePassword;
    private Map remoteEngines = new Hashtable();

    public InterWorkflowConfig() throws XmlException, IOException {
        String home = System.getProperty("nautica.home");
        String separator = System.getProperty("file.separator");
        String path = home + separator + "config" + separator + CONFIG;
        File confFile = new File(path);
        FileInputStream in = new FileInputStream(confFile);
        XmlOptions opts = new XmlOptions();
        opts.setCharacterEncoding("utf-8");
        EngineConfigDocument doc = EngineConfigDocument.Factory.parse((InputStream)in, (XmlOptions)opts);
        ((InputStream)in).close();
        this.load(doc);
    }

    private void load(EngineConfigDocument doc) throws XmlException, IOException {
        EngineConfigDocument.EngineConfig config = doc.getEngineConfig();
        EngineDocument.Engine local = config.getEngine();
        this.engineID = local.getId();
        this.enginePassword = local.getPassword();
        RemoteEnginesDocument.RemoteEngines remotes = config.getRemoteEngines();
        EngineDocument.Engine[] engines = remotes.getEngineArray();
        for (int i = 0; i < engines.length; ++i) {
            String id = engines[i].getId();
            String pass = engines[i].getPassword();
            String url = engines[i].getUrl();
            if (id == null || id.trim().equals("")) {
                String E0162 = StringManager.get("E0162");
                throw new XmlException(E0162);
            }
            EngineInfo info = new EngineInfo(id, pass, url);
            this.remoteEngines.put(id, info);
        }
    }

    String getLocalEngineID() {
        return this.engineID;
    }

    String getPassword() {
        return this.enginePassword;
    }

    EngineInfo getEngineInfo(String eid) {
        return (EngineInfo)this.remoteEngines.get(eid);
    }

    class EngineInfo {
        private String engineID;
        private String enginePassword;
        private String engineUrl;

        public EngineInfo(String id, String pass, String url) {
            this.engineID = id;
            this.enginePassword = pass;
            this.engineUrl = url;
        }

        String getID() {
            return this.engineID;
        }

        String getPassword() {
            if (this.enginePassword == null) {
                return "";
            }
            return this.enginePassword;
        }

        String getURL() {
            if (this.engineUrl == null) {
                return "";
            }
            return this.engineUrl;
        }
    }
}

